/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.privilegedaccess.group;

import com.microsoft.graph.identitygovernance.privilegedaccess.group.assignmentapprovals.AssignmentApprovalsRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.assignmentscheduleinstances.AssignmentScheduleInstancesRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.assignmentschedulerequests.AssignmentScheduleRequestsRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.assignmentschedules.AssignmentSchedulesRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.eligibilityscheduleinstances.EligibilityScheduleInstancesRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.eligibilityschedulerequests.EligibilityScheduleRequestsRequestBuilder;
import com.microsoft.graph.identitygovernance.privilegedaccess.group.eligibilityschedules.EligibilitySchedulesRequestBuilder;
import com.microsoft.graph.models.PrivilegedAccessGroup;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class GroupRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AssignmentApprovalsRequestBuilder assignmentApprovals() {
        return new AssignmentApprovalsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AssignmentScheduleInstancesRequestBuilder assignmentScheduleInstances() {
        return new AssignmentScheduleInstancesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AssignmentScheduleRequestsRequestBuilder assignmentScheduleRequests() {
        return new AssignmentScheduleRequestsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public AssignmentSchedulesRequestBuilder assignmentSchedules() {
        return new AssignmentSchedulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public EligibilityScheduleInstancesRequestBuilder eligibilityScheduleInstances() {
        return new EligibilityScheduleInstancesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public EligibilityScheduleRequestsRequestBuilder eligibilityScheduleRequests() {
        return new EligibilityScheduleRequestsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public EligibilitySchedulesRequestBuilder eligibilitySchedules() {
        return new EligibilitySchedulesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public GroupRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityGovernance/privilegedAccess/group{?%24expand,%24select}", pathParameters);
    }

    public GroupRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/identityGovernance/privilegedAccess/group{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public PrivilegedAccessGroup get() {
        return this.get(null);
    }

    @Nullable
    public PrivilegedAccessGroup get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (PrivilegedAccessGroup)this.requestAdapter.send(requestInfo, errorMapping, PrivilegedAccessGroup::createFromDiscriminatorValue);
    }

    @Nullable
    public PrivilegedAccessGroup patch(@Nonnull PrivilegedAccessGroup body) {
        return this.patch(body, null);
    }

    @Nullable
    public PrivilegedAccessGroup patch(@Nonnull PrivilegedAccessGroup body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (PrivilegedAccessGroup)this.requestAdapter.send(requestInfo, errorMapping, PrivilegedAccessGroup::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, "{+baseurl}/identityGovernance/privilegedAccess/group", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull PrivilegedAccessGroup body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull PrivilegedAccessGroup body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/identityGovernance/privilegedAccess/group", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public GroupRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new GroupRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

