/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AppKeyCredentialRestrictionType;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class KeyCredentialConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public KeyCredentialConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static KeyCredentialConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new KeyCredentialConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("maxLifetime", n -> this.setMaxLifetime(n.getPeriodAndDurationValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("restrictForAppsCreatedAfterDateTime", n -> this.setRestrictForAppsCreatedAfterDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("restrictionType", n -> this.setRestrictionType((AppKeyCredentialRestrictionType)n.getEnumValue(AppKeyCredentialRestrictionType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public PeriodAndDuration getMaxLifetime() {
        return (PeriodAndDuration)this.backingStore.get("maxLifetime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getRestrictForAppsCreatedAfterDateTime() {
        return (OffsetDateTime)this.backingStore.get("restrictForAppsCreatedAfterDateTime");
    }

    @Nullable
    public AppKeyCredentialRestrictionType getRestrictionType() {
        return (AppKeyCredentialRestrictionType)((Object)this.backingStore.get("restrictionType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writePeriodAndDurationValue("maxLifetime", this.getMaxLifetime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("restrictForAppsCreatedAfterDateTime", this.getRestrictForAppsCreatedAfterDateTime());
        writer.writeEnumValue("restrictionType", (Enum)this.getRestrictionType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setMaxLifetime(@Nullable PeriodAndDuration value) {
        this.backingStore.set("maxLifetime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRestrictForAppsCreatedAfterDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("restrictForAppsCreatedAfterDateTime", (Object)value);
    }

    public void setRestrictionType(@Nullable AppKeyCredentialRestrictionType value) {
        this.backingStore.set("restrictionType", (Object)value);
    }
}

