/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CourseStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.LearningAssignment;
import com.microsoft.graph.models.LearningSelfInitiatedCourse;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class LearningCourseActivity
extends Entity
implements Parsable {
    @Nonnull
    public static LearningCourseActivity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.learningAssignment": {
                    return new LearningAssignment();
                }
                case "#microsoft.graph.learningSelfInitiatedCourse": {
                    return new LearningSelfInitiatedCourse();
                }
            }
        }
        return new LearningCourseActivity();
    }

    @Nullable
    public OffsetDateTime getCompletedDateTime() {
        return (OffsetDateTime)this.backingStore.get("completedDateTime");
    }

    @Nullable
    public Integer getCompletionPercentage() {
        return (Integer)this.backingStore.get("completionPercentage");
    }

    @Nullable
    public String getExternalcourseActivityId() {
        return (String)this.backingStore.get("externalcourseActivityId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completedDateTime", n -> this.setCompletedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("completionPercentage", n -> this.setCompletionPercentage(n.getIntegerValue()));
        deserializerMap.put("externalcourseActivityId", n -> this.setExternalcourseActivityId(n.getStringValue()));
        deserializerMap.put("learnerUserId", n -> this.setLearnerUserId(n.getStringValue()));
        deserializerMap.put("learningContentId", n -> this.setLearningContentId(n.getStringValue()));
        deserializerMap.put("learningProviderId", n -> this.setLearningProviderId(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((CourseStatus)n.getEnumValue(CourseStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getLearnerUserId() {
        return (String)this.backingStore.get("learnerUserId");
    }

    @Nullable
    public String getLearningContentId() {
        return (String)this.backingStore.get("learningContentId");
    }

    @Nullable
    public String getLearningProviderId() {
        return (String)this.backingStore.get("learningProviderId");
    }

    @Nullable
    public CourseStatus getStatus() {
        return (CourseStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completedDateTime", this.getCompletedDateTime());
        writer.writeIntegerValue("completionPercentage", this.getCompletionPercentage());
        writer.writeStringValue("externalcourseActivityId", this.getExternalcourseActivityId());
        writer.writeStringValue("learnerUserId", this.getLearnerUserId());
        writer.writeStringValue("learningContentId", this.getLearningContentId());
        writer.writeStringValue("learningProviderId", this.getLearningProviderId());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCompletedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completedDateTime", (Object)value);
    }

    public void setCompletionPercentage(@Nullable Integer value) {
        this.backingStore.set("completionPercentage", (Object)value);
    }

    public void setExternalcourseActivityId(@Nullable String value) {
        this.backingStore.set("externalcourseActivityId", (Object)value);
    }

    public void setLearnerUserId(@Nullable String value) {
        this.backingStore.set("learnerUserId", (Object)value);
    }

    public void setLearningContentId(@Nullable String value) {
        this.backingStore.set("learningContentId", (Object)value);
    }

    public void setLearningProviderId(@Nullable String value) {
        this.backingStore.set("learningProviderId", (Object)value);
    }

    public void setStatus(@Nullable CourseStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

