/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.MailSearchFolder;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.MessageRule;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MailFolder
extends Entity
implements Parsable {
    @Nonnull
    public static MailFolder createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.mailSearchFolder": {
                    return new MailSearchFolder();
                }
            }
        }
        return new MailFolder();
    }

    @Nullable
    public Integer getChildFolderCount() {
        return (Integer)this.backingStore.get("childFolderCount");
    }

    @Nullable
    public List<MailFolder> getChildFolders() {
        return (List)this.backingStore.get("childFolders");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("childFolderCount", n -> this.setChildFolderCount(n.getIntegerValue()));
        deserializerMap.put("childFolders", n -> this.setChildFolders(n.getCollectionOfObjectValues(MailFolder::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isHidden", n -> this.setIsHidden(n.getBooleanValue()));
        deserializerMap.put("messageRules", n -> this.setMessageRules(n.getCollectionOfObjectValues(MessageRule::createFromDiscriminatorValue)));
        deserializerMap.put("messages", n -> this.setMessages(n.getCollectionOfObjectValues(Message::createFromDiscriminatorValue)));
        deserializerMap.put("multiValueExtendedProperties", n -> this.setMultiValueExtendedProperties(n.getCollectionOfObjectValues(MultiValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("parentFolderId", n -> this.setParentFolderId(n.getStringValue()));
        deserializerMap.put("singleValueExtendedProperties", n -> this.setSingleValueExtendedProperties(n.getCollectionOfObjectValues(SingleValueLegacyExtendedProperty::createFromDiscriminatorValue)));
        deserializerMap.put("totalItemCount", n -> this.setTotalItemCount(n.getIntegerValue()));
        deserializerMap.put("unreadItemCount", n -> this.setUnreadItemCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsHidden() {
        return (Boolean)this.backingStore.get("isHidden");
    }

    @Nullable
    public List<MessageRule> getMessageRules() {
        return (List)this.backingStore.get("messageRules");
    }

    @Nullable
    public List<Message> getMessages() {
        return (List)this.backingStore.get("messages");
    }

    @Nullable
    public List<MultiValueLegacyExtendedProperty> getMultiValueExtendedProperties() {
        return (List)this.backingStore.get("multiValueExtendedProperties");
    }

    @Nullable
    public String getParentFolderId() {
        return (String)this.backingStore.get("parentFolderId");
    }

    @Nullable
    public List<SingleValueLegacyExtendedProperty> getSingleValueExtendedProperties() {
        return (List)this.backingStore.get("singleValueExtendedProperties");
    }

    @Nullable
    public Integer getTotalItemCount() {
        return (Integer)this.backingStore.get("totalItemCount");
    }

    @Nullable
    public Integer getUnreadItemCount() {
        return (Integer)this.backingStore.get("unreadItemCount");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("childFolderCount", this.getChildFolderCount());
        writer.writeCollectionOfObjectValues("childFolders", this.getChildFolders());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isHidden", this.getIsHidden());
        writer.writeCollectionOfObjectValues("messageRules", this.getMessageRules());
        writer.writeCollectionOfObjectValues("messages", this.getMessages());
        writer.writeCollectionOfObjectValues("multiValueExtendedProperties", this.getMultiValueExtendedProperties());
        writer.writeStringValue("parentFolderId", this.getParentFolderId());
        writer.writeCollectionOfObjectValues("singleValueExtendedProperties", this.getSingleValueExtendedProperties());
        writer.writeIntegerValue("totalItemCount", this.getTotalItemCount());
        writer.writeIntegerValue("unreadItemCount", this.getUnreadItemCount());
    }

    public void setChildFolderCount(@Nullable Integer value) {
        this.backingStore.set("childFolderCount", (Object)value);
    }

    public void setChildFolders(@Nullable List<MailFolder> value) {
        this.backingStore.set("childFolders", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsHidden(@Nullable Boolean value) {
        this.backingStore.set("isHidden", (Object)value);
    }

    public void setMessageRules(@Nullable List<MessageRule> value) {
        this.backingStore.set("messageRules", value);
    }

    public void setMessages(@Nullable List<Message> value) {
        this.backingStore.set("messages", value);
    }

    public void setMultiValueExtendedProperties(@Nullable List<MultiValueLegacyExtendedProperty> value) {
        this.backingStore.set("multiValueExtendedProperties", value);
    }

    public void setParentFolderId(@Nullable String value) {
        this.backingStore.set("parentFolderId", (Object)value);
    }

    public void setSingleValueExtendedProperties(@Nullable List<SingleValueLegacyExtendedProperty> value) {
        this.backingStore.set("singleValueExtendedProperties", value);
    }

    public void setTotalItemCount(@Nullable Integer value) {
        this.backingStore.set("totalItemCount", (Object)value);
    }

    public void setUnreadItemCount(@Nullable Integer value) {
        this.backingStore.set("unreadItemCount", (Object)value);
    }
}

