/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AutomaticRepliesMailTips;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.MailTipsError;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.RecipientScopeType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MailTips
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MailTips() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MailTips createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MailTips();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public AutomaticRepliesMailTips getAutomaticReplies() {
        return (AutomaticRepliesMailTips)this.backingStore.get("automaticReplies");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCustomMailTip() {
        return (String)this.backingStore.get("customMailTip");
    }

    @Nullable
    public Boolean getDeliveryRestricted() {
        return (Boolean)this.backingStore.get("deliveryRestricted");
    }

    @Nullable
    public EmailAddress getEmailAddress() {
        return (EmailAddress)this.backingStore.get("emailAddress");
    }

    @Nullable
    public MailTipsError getError() {
        return (MailTipsError)this.backingStore.get("error");
    }

    @Nullable
    public Integer getExternalMemberCount() {
        return (Integer)this.backingStore.get("externalMemberCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("automaticReplies", n -> this.setAutomaticReplies((AutomaticRepliesMailTips)n.getObjectValue(AutomaticRepliesMailTips::createFromDiscriminatorValue)));
        deserializerMap.put("customMailTip", n -> this.setCustomMailTip(n.getStringValue()));
        deserializerMap.put("deliveryRestricted", n -> this.setDeliveryRestricted(n.getBooleanValue()));
        deserializerMap.put("emailAddress", n -> this.setEmailAddress((EmailAddress)n.getObjectValue(EmailAddress::createFromDiscriminatorValue)));
        deserializerMap.put("error", n -> this.setError((MailTipsError)n.getObjectValue(MailTipsError::createFromDiscriminatorValue)));
        deserializerMap.put("externalMemberCount", n -> this.setExternalMemberCount(n.getIntegerValue()));
        deserializerMap.put("isModerated", n -> this.setIsModerated(n.getBooleanValue()));
        deserializerMap.put("mailboxFull", n -> this.setMailboxFull(n.getBooleanValue()));
        deserializerMap.put("maxMessageSize", n -> this.setMaxMessageSize(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("recipientScope", n -> this.setRecipientScope(n.getEnumSetValue(RecipientScopeType::forValue)));
        deserializerMap.put("recipientSuggestions", n -> this.setRecipientSuggestions(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("totalMemberCount", n -> this.setTotalMemberCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsModerated() {
        return (Boolean)this.backingStore.get("isModerated");
    }

    @Nullable
    public Boolean getMailboxFull() {
        return (Boolean)this.backingStore.get("mailboxFull");
    }

    @Nullable
    public Integer getMaxMessageSize() {
        return (Integer)this.backingStore.get("maxMessageSize");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public EnumSet<RecipientScopeType> getRecipientScope() {
        return (EnumSet)this.backingStore.get("recipientScope");
    }

    @Nullable
    public List<Recipient> getRecipientSuggestions() {
        return (List)this.backingStore.get("recipientSuggestions");
    }

    @Nullable
    public Integer getTotalMemberCount() {
        return (Integer)this.backingStore.get("totalMemberCount");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("automaticReplies", (Parsable)this.getAutomaticReplies(), new Parsable[0]);
        writer.writeStringValue("customMailTip", this.getCustomMailTip());
        writer.writeBooleanValue("deliveryRestricted", this.getDeliveryRestricted());
        writer.writeObjectValue("emailAddress", (Parsable)this.getEmailAddress(), new Parsable[0]);
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeIntegerValue("externalMemberCount", this.getExternalMemberCount());
        writer.writeBooleanValue("isModerated", this.getIsModerated());
        writer.writeBooleanValue("mailboxFull", this.getMailboxFull());
        writer.writeIntegerValue("maxMessageSize", this.getMaxMessageSize());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumSetValue("recipientScope", this.getRecipientScope());
        writer.writeCollectionOfObjectValues("recipientSuggestions", this.getRecipientSuggestions());
        writer.writeIntegerValue("totalMemberCount", this.getTotalMemberCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAutomaticReplies(@Nullable AutomaticRepliesMailTips value) {
        this.backingStore.set("automaticReplies", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCustomMailTip(@Nullable String value) {
        this.backingStore.set("customMailTip", (Object)value);
    }

    public void setDeliveryRestricted(@Nullable Boolean value) {
        this.backingStore.set("deliveryRestricted", (Object)value);
    }

    public void setEmailAddress(@Nullable EmailAddress value) {
        this.backingStore.set("emailAddress", (Object)value);
    }

    public void setError(@Nullable MailTipsError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setExternalMemberCount(@Nullable Integer value) {
        this.backingStore.set("externalMemberCount", (Object)value);
    }

    public void setIsModerated(@Nullable Boolean value) {
        this.backingStore.set("isModerated", (Object)value);
    }

    public void setMailboxFull(@Nullable Boolean value) {
        this.backingStore.set("mailboxFull", (Object)value);
    }

    public void setMaxMessageSize(@Nullable Integer value) {
        this.backingStore.set("maxMessageSize", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRecipientScope(@Nullable EnumSet<RecipientScopeType> value) {
        this.backingStore.set("recipientScope", value);
    }

    public void setRecipientSuggestions(@Nullable List<Recipient> value) {
        this.backingStore.set("recipientSuggestions", value);
    }

    public void setTotalMemberCount(@Nullable Integer value) {
        this.backingStore.set("totalMemberCount", (Object)value);
    }
}

