/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.OperationStatus;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Operation
extends Entity
implements Parsable {
    @Nonnull
    public static Operation createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.onenoteOperation": {
                    return new OnenoteOperation();
                }
            }
        }
        return new Operation();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastActionDateTime", n -> this.setLastActionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((OperationStatus)n.getEnumValue(OperationStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastActionDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastActionDateTime");
    }

    @Nullable
    public OperationStatus getStatus() {
        return (OperationStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("lastActionDateTime", this.getLastActionDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setLastActionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastActionDateTime", (Object)value);
    }

    public void setStatus(@Nullable OperationStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

