/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.devicemanagement.virtualendpoint.cloudpcs.item.resize;

import com.microsoft.graph.devicemanagement.virtualendpoint.cloudpcs.item.resize.ResizePostRequestBody;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ResizeRequestBuilder
extends BaseRequestBuilder {
    public ResizeRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/deviceManagement/virtualEndpoint/cloudPCs/{cloudPC%2Did}/resize", pathParameters);
    }

    public ResizeRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/deviceManagement/virtualEndpoint/cloudPCs/{cloudPC%2Did}/resize", rawUrl);
    }

    public void post(@Nonnull ResizePostRequestBody body) {
        this.post(body, null);
    }

    public void post(@Nonnull ResizePostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ResizePostRequestBody body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ResizePostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ResizeRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ResizeRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

