/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CertificateAuthorityType;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CertificateAuthorityDetail
extends DirectoryObject
implements Parsable {
    public CertificateAuthorityDetail() {
        this.setOdataType("#microsoft.graph.certificateAuthorityDetail");
    }

    @Nonnull
    public static CertificateAuthorityDetail createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CertificateAuthorityDetail();
    }

    @Nullable
    public byte[] getCertificate() {
        return (byte[])this.backingStore.get("certificate");
    }

    @Nullable
    public CertificateAuthorityType getCertificateAuthorityType() {
        return (CertificateAuthorityType)((Object)this.backingStore.get("certificateAuthorityType"));
    }

    @Nullable
    public String getCertificateRevocationListUrl() {
        return (String)this.backingStore.get("certificateRevocationListUrl");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDeltaCertificateRevocationListUrl() {
        return (String)this.backingStore.get("deltaCertificateRevocationListUrl");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("certificate", n -> this.setCertificate(n.getByteArrayValue()));
        deserializerMap.put("certificateAuthorityType", n -> this.setCertificateAuthorityType((CertificateAuthorityType)n.getEnumValue(CertificateAuthorityType::forValue)));
        deserializerMap.put("certificateRevocationListUrl", n -> this.setCertificateRevocationListUrl(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("deltaCertificateRevocationListUrl", n -> this.setDeltaCertificateRevocationListUrl(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("isIssuerHintEnabled", n -> this.setIsIssuerHintEnabled(n.getBooleanValue()));
        deserializerMap.put("issuer", n -> this.setIssuer(n.getStringValue()));
        deserializerMap.put("issuerSubjectKeyIdentifier", n -> this.setIssuerSubjectKeyIdentifier(n.getStringValue()));
        deserializerMap.put("thumbprint", n -> this.setThumbprint(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsIssuerHintEnabled() {
        return (Boolean)this.backingStore.get("isIssuerHintEnabled");
    }

    @Nullable
    public String getIssuer() {
        return (String)this.backingStore.get("issuer");
    }

    @Nullable
    public String getIssuerSubjectKeyIdentifier() {
        return (String)this.backingStore.get("issuerSubjectKeyIdentifier");
    }

    @Nullable
    public String getThumbprint() {
        return (String)this.backingStore.get("thumbprint");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeByteArrayValue("certificate", this.getCertificate());
        writer.writeEnumValue("certificateAuthorityType", (Enum)this.getCertificateAuthorityType());
        writer.writeStringValue("certificateRevocationListUrl", this.getCertificateRevocationListUrl());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("deltaCertificateRevocationListUrl", this.getDeltaCertificateRevocationListUrl());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeBooleanValue("isIssuerHintEnabled", this.getIsIssuerHintEnabled());
        writer.writeStringValue("issuer", this.getIssuer());
        writer.writeStringValue("issuerSubjectKeyIdentifier", this.getIssuerSubjectKeyIdentifier());
        writer.writeStringValue("thumbprint", this.getThumbprint());
    }

    public void setCertificate(@Nullable byte[] value) {
        this.backingStore.set("certificate", (Object)value);
    }

    public void setCertificateAuthorityType(@Nullable CertificateAuthorityType value) {
        this.backingStore.set("certificateAuthorityType", (Object)value);
    }

    public void setCertificateRevocationListUrl(@Nullable String value) {
        this.backingStore.set("certificateRevocationListUrl", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDeltaCertificateRevocationListUrl(@Nullable String value) {
        this.backingStore.set("deltaCertificateRevocationListUrl", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setIsIssuerHintEnabled(@Nullable Boolean value) {
        this.backingStore.set("isIssuerHintEnabled", (Object)value);
    }

    public void setIssuer(@Nullable String value) {
        this.backingStore.set("issuer", (Object)value);
    }

    public void setIssuerSubjectKeyIdentifier(@Nullable String value) {
        this.backingStore.set("issuerSubjectKeyIdentifier", (Object)value);
    }

    public void setThumbprint(@Nullable String value) {
        this.backingStore.set("thumbprint", (Object)value);
    }
}

