/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AadUserConversationMember;
import com.microsoft.graph.models.AnonymousGuestConversationMember;
import com.microsoft.graph.models.AzureCommunicationServicesUserConversationMember;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.MicrosoftAccountUserConversationMember;
import com.microsoft.graph.models.PhoneUserConversationMember;
import com.microsoft.graph.models.SkypeForBusinessUserConversationMember;
import com.microsoft.graph.models.SkypeUserConversationMember;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConversationMember
extends Entity
implements Parsable {
    @Nonnull
    public static ConversationMember createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.aadUserConversationMember": {
                    return new AadUserConversationMember();
                }
                case "#microsoft.graph.anonymousGuestConversationMember": {
                    return new AnonymousGuestConversationMember();
                }
                case "#microsoft.graph.azureCommunicationServicesUserConversationMember": {
                    return new AzureCommunicationServicesUserConversationMember();
                }
                case "#microsoft.graph.microsoftAccountUserConversationMember": {
                    return new MicrosoftAccountUserConversationMember();
                }
                case "#microsoft.graph.phoneUserConversationMember": {
                    return new PhoneUserConversationMember();
                }
                case "#microsoft.graph.skypeForBusinessUserConversationMember": {
                    return new SkypeForBusinessUserConversationMember();
                }
                case "#microsoft.graph.skypeUserConversationMember": {
                    return new SkypeUserConversationMember();
                }
            }
        }
        return new ConversationMember();
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("roles", n -> this.setRoles(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("visibleHistoryStartDateTime", n -> this.setVisibleHistoryStartDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public List<String> getRoles() {
        return (List)this.backingStore.get("roles");
    }

    @Nullable
    public OffsetDateTime getVisibleHistoryStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("visibleHistoryStartDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfPrimitiveValues("roles", this.getRoles());
        writer.writeOffsetDateTimeValue("visibleHistoryStartDateTime", this.getVisibleHistoryStartDateTime());
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setRoles(@Nullable List<String> value) {
        this.backingStore.set("roles", value);
    }

    public void setVisibleHistoryStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("visibleHistoryStartDateTime", (Object)value);
    }
}

