/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsDeviceUsageType;
import com.microsoft.graph.models.WindowsUserType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OutOfBoxExperienceSetting
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public OutOfBoxExperienceSetting() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static OutOfBoxExperienceSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OutOfBoxExperienceSetting();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public WindowsDeviceUsageType getDeviceUsageType() {
        return (WindowsDeviceUsageType)((Object)this.backingStore.get("deviceUsageType"));
    }

    @Nullable
    public Boolean getEscapeLinkHidden() {
        return (Boolean)this.backingStore.get("escapeLinkHidden");
    }

    @Nullable
    public Boolean getEulaHidden() {
        return (Boolean)this.backingStore.get("eulaHidden");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("deviceUsageType", n -> this.setDeviceUsageType((WindowsDeviceUsageType)n.getEnumValue(WindowsDeviceUsageType::forValue)));
        deserializerMap.put("escapeLinkHidden", n -> this.setEscapeLinkHidden(n.getBooleanValue()));
        deserializerMap.put("eulaHidden", n -> this.setEulaHidden(n.getBooleanValue()));
        deserializerMap.put("keyboardSelectionPageSkipped", n -> this.setKeyboardSelectionPageSkipped(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("privacySettingsHidden", n -> this.setPrivacySettingsHidden(n.getBooleanValue()));
        deserializerMap.put("userType", n -> this.setUserType((WindowsUserType)n.getEnumValue(WindowsUserType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getKeyboardSelectionPageSkipped() {
        return (Boolean)this.backingStore.get("keyboardSelectionPageSkipped");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getPrivacySettingsHidden() {
        return (Boolean)this.backingStore.get("privacySettingsHidden");
    }

    @Nullable
    public WindowsUserType getUserType() {
        return (WindowsUserType)((Object)this.backingStore.get("userType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("deviceUsageType", (Enum)this.getDeviceUsageType());
        writer.writeBooleanValue("escapeLinkHidden", this.getEscapeLinkHidden());
        writer.writeBooleanValue("eulaHidden", this.getEulaHidden());
        writer.writeBooleanValue("keyboardSelectionPageSkipped", this.getKeyboardSelectionPageSkipped());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("privacySettingsHidden", this.getPrivacySettingsHidden());
        writer.writeEnumValue("userType", (Enum)this.getUserType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDeviceUsageType(@Nullable WindowsDeviceUsageType value) {
        this.backingStore.set("deviceUsageType", (Object)value);
    }

    public void setEscapeLinkHidden(@Nullable Boolean value) {
        this.backingStore.set("escapeLinkHidden", (Object)value);
    }

    public void setEulaHidden(@Nullable Boolean value) {
        this.backingStore.set("eulaHidden", (Object)value);
    }

    public void setKeyboardSelectionPageSkipped(@Nullable Boolean value) {
        this.backingStore.set("keyboardSelectionPageSkipped", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrivacySettingsHidden(@Nullable Boolean value) {
        this.backingStore.set("privacySettingsHidden", (Object)value);
    }

    public void setUserType(@Nullable WindowsUserType value) {
        this.backingStore.set("userType", (Object)value);
    }
}

