/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.models.AuthenticationMethodTarget;
import com.microsoft.graph.models.X509CertificateAuthenticationModeConfiguration;
import com.microsoft.graph.models.X509CertificateCRLValidationConfiguration;
import com.microsoft.graph.models.X509CertificateUserBinding;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class X509CertificateAuthenticationMethodConfiguration
extends AuthenticationMethodConfiguration
implements Parsable {
    public X509CertificateAuthenticationMethodConfiguration() {
        this.setOdataType("#microsoft.graph.x509CertificateAuthenticationMethodConfiguration");
    }

    @Nonnull
    public static X509CertificateAuthenticationMethodConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new X509CertificateAuthenticationMethodConfiguration();
    }

    @Nullable
    public X509CertificateAuthenticationModeConfiguration getAuthenticationModeConfiguration() {
        return (X509CertificateAuthenticationModeConfiguration)this.backingStore.get("authenticationModeConfiguration");
    }

    @Nullable
    public List<X509CertificateUserBinding> getCertificateUserBindings() {
        return (List)this.backingStore.get("certificateUserBindings");
    }

    @Nullable
    public X509CertificateCRLValidationConfiguration getCrlValidationConfiguration() {
        return (X509CertificateCRLValidationConfiguration)this.backingStore.get("crlValidationConfiguration");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("authenticationModeConfiguration", n -> this.setAuthenticationModeConfiguration((X509CertificateAuthenticationModeConfiguration)n.getObjectValue(X509CertificateAuthenticationModeConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("certificateUserBindings", n -> this.setCertificateUserBindings(n.getCollectionOfObjectValues(X509CertificateUserBinding::createFromDiscriminatorValue)));
        deserializerMap.put("crlValidationConfiguration", n -> this.setCrlValidationConfiguration((X509CertificateCRLValidationConfiguration)n.getObjectValue(X509CertificateCRLValidationConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("includeTargets", n -> this.setIncludeTargets(n.getCollectionOfObjectValues(AuthenticationMethodTarget::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<AuthenticationMethodTarget> getIncludeTargets() {
        return (List)this.backingStore.get("includeTargets");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("authenticationModeConfiguration", (Parsable)this.getAuthenticationModeConfiguration(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("certificateUserBindings", this.getCertificateUserBindings());
        writer.writeObjectValue("crlValidationConfiguration", (Parsable)this.getCrlValidationConfiguration(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("includeTargets", this.getIncludeTargets());
    }

    public void setAuthenticationModeConfiguration(@Nullable X509CertificateAuthenticationModeConfiguration value) {
        this.backingStore.set("authenticationModeConfiguration", (Object)value);
    }

    public void setCertificateUserBindings(@Nullable List<X509CertificateUserBinding> value) {
        this.backingStore.set("certificateUserBindings", value);
    }

    public void setCrlValidationConfiguration(@Nullable X509CertificateCRLValidationConfiguration value) {
        this.backingStore.set("crlValidationConfiguration", (Object)value);
    }

    public void setIncludeTargets(@Nullable List<AuthenticationMethodTarget> value) {
        this.backingStore.set("includeTargets", value);
    }
}

