/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.datasecurityandgovernance.processcontentasync;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.security.datasecurityandgovernance.processcontentasync.ProcessContentAsyncPostRequestBody;
import com.microsoft.graph.security.datasecurityandgovernance.processcontentasync.ProcessContentAsyncPostResponse;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessContentAsyncRequestBuilder
extends BaseRequestBuilder {
    public ProcessContentAsyncRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/dataSecurityAndGovernance/processContentAsync", pathParameters);
    }

    public ProcessContentAsyncRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/dataSecurityAndGovernance/processContentAsync", rawUrl);
    }

    @Nullable
    public ProcessContentAsyncPostResponse post(@Nonnull ProcessContentAsyncPostRequestBody body) {
        return this.post(body, null);
    }

    @Nullable
    public ProcessContentAsyncPostResponse post(@Nonnull ProcessContentAsyncPostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (ProcessContentAsyncPostResponse)this.requestAdapter.send(requestInfo, errorMapping, ProcessContentAsyncPostResponse::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ProcessContentAsyncPostRequestBody body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ProcessContentAsyncPostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ProcessContentAsyncRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ProcessContentAsyncRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

