/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.datasecurityandgovernance.protectionscopes.compute;

import com.microsoft.graph.models.DeviceMetadata;
import com.microsoft.graph.models.IntegratedApplicationMetadata;
import com.microsoft.graph.models.PolicyLocation;
import com.microsoft.graph.models.PolicyPivotProperty;
import com.microsoft.graph.models.UserActivityTypes;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ComputePostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ComputePostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ComputePostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ComputePostRequestBody();
    }

    @Nullable
    public EnumSet<UserActivityTypes> getActivities() {
        return (EnumSet)this.backingStore.get("activities");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public DeviceMetadata getDeviceMetadata() {
        return (DeviceMetadata)this.backingStore.get("deviceMetadata");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("activities", n -> this.setActivities(n.getEnumSetValue(UserActivityTypes::forValue)));
        deserializerMap.put("deviceMetadata", n -> this.setDeviceMetadata((DeviceMetadata)n.getObjectValue(DeviceMetadata::createFromDiscriminatorValue)));
        deserializerMap.put("integratedAppMetadata", n -> this.setIntegratedAppMetadata((IntegratedApplicationMetadata)n.getObjectValue(IntegratedApplicationMetadata::createFromDiscriminatorValue)));
        deserializerMap.put("locations", n -> this.setLocations(n.getCollectionOfObjectValues(PolicyLocation::createFromDiscriminatorValue)));
        deserializerMap.put("pivotOn", n -> this.setPivotOn((PolicyPivotProperty)n.getEnumValue(PolicyPivotProperty::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IntegratedApplicationMetadata getIntegratedAppMetadata() {
        return (IntegratedApplicationMetadata)this.backingStore.get("integratedAppMetadata");
    }

    @Nullable
    public List<PolicyLocation> getLocations() {
        return (List)this.backingStore.get("locations");
    }

    @Nullable
    public PolicyPivotProperty getPivotOn() {
        return (PolicyPivotProperty)((Object)this.backingStore.get("pivotOn"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumSetValue("activities", this.getActivities());
        writer.writeObjectValue("deviceMetadata", (Parsable)this.getDeviceMetadata(), new Parsable[0]);
        writer.writeObjectValue("integratedAppMetadata", (Parsable)this.getIntegratedAppMetadata(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("locations", this.getLocations());
        writer.writeEnumValue("pivotOn", (Enum)this.getPivotOn());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActivities(@Nullable EnumSet<UserActivityTypes> value) {
        this.backingStore.set("activities", value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDeviceMetadata(@Nullable DeviceMetadata value) {
        this.backingStore.set("deviceMetadata", (Object)value);
    }

    public void setIntegratedAppMetadata(@Nullable IntegratedApplicationMetadata value) {
        this.backingStore.set("integratedAppMetadata", (Object)value);
    }

    public void setLocations(@Nullable List<PolicyLocation> value) {
        this.backingStore.set("locations", value);
    }

    public void setPivotOn(@Nullable PolicyPivotProperty value) {
        this.backingStore.set("pivotOn", (Object)value);
    }
}

