/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.SensitivityLabel;
import com.microsoft.graph.models.TenantDataSecurityAndGovernance;
import com.microsoft.graph.models.UserDataSecurityAndGovernance;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DataSecurityAndGovernance
extends Entity
implements Parsable {
    @Nonnull
    public static DataSecurityAndGovernance createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.tenantDataSecurityAndGovernance": {
                    return new TenantDataSecurityAndGovernance();
                }
                case "#microsoft.graph.userDataSecurityAndGovernance": {
                    return new UserDataSecurityAndGovernance();
                }
            }
        }
        return new DataSecurityAndGovernance();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("sensitivityLabels", n -> this.setSensitivityLabels(n.getCollectionOfObjectValues(SensitivityLabel::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<SensitivityLabel> getSensitivityLabels() {
        return (List)this.backingStore.get("sensitivityLabels");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("sensitivityLabels", this.getSensitivityLabels());
    }

    public void setSensitivityLabels(@Nullable List<SensitivityLabel> value) {
        this.backingStore.set("sensitivityLabels", value);
    }
}

