/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationItemBody;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationFeedback
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EducationFeedback() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EducationFeedback createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationFeedback();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public IdentitySet getFeedbackBy() {
        return (IdentitySet)this.backingStore.get("feedbackBy");
    }

    @Nullable
    public OffsetDateTime getFeedbackDateTime() {
        return (OffsetDateTime)this.backingStore.get("feedbackDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("feedbackBy", n -> this.setFeedbackBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("feedbackDateTime", n -> this.setFeedbackDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("text", n -> this.setText((EducationItemBody)n.getObjectValue(EducationItemBody::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public EducationItemBody getText() {
        return (EducationItemBody)this.backingStore.get("text");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("feedbackBy", (Parsable)this.getFeedbackBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("feedbackDateTime", this.getFeedbackDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("text", (Parsable)this.getText(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setFeedbackBy(@Nullable IdentitySet value) {
        this.backingStore.set("feedbackBy", (Object)value);
    }

    public void setFeedbackDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("feedbackDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setText(@Nullable EducationItemBody value) {
        this.backingStore.set("text", (Object)value);
    }
}

