/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Location;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EmergencyCallerInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EmergencyCallerInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EmergencyCallerInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EmergencyCallerInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("location", n -> this.setLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("phoneNumber", n -> this.setPhoneNumber(n.getStringValue()));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        deserializerMap.put("upn", n -> this.setUpn(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Location getLocation() {
        return (Location)this.backingStore.get("location");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPhoneNumber() {
        return (String)this.backingStore.get("phoneNumber");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Nullable
    public String getUpn() {
        return (String)this.backingStore.get("upn");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("phoneNumber", this.getPhoneNumber());
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeStringValue("upn", this.getUpn());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLocation(@Nullable Location value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPhoneNumber(@Nullable String value) {
        this.backingStore.set("phoneNumber", (Object)value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }

    public void setUpn(@Nullable String value) {
        this.backingStore.set("upn", (Object)value);
    }
}

