/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BroadcastMeetingSettings;
import com.microsoft.graph.models.CallRecording;
import com.microsoft.graph.models.CallTranscript;
import com.microsoft.graph.models.MeetingParticipants;
import com.microsoft.graph.models.OnlineMeetingBase;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnlineMeeting
extends OnlineMeetingBase
implements Parsable {
    public OnlineMeeting() {
        this.setOdataType("#microsoft.graph.onlineMeeting");
    }

    @Nonnull
    public static OnlineMeeting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OnlineMeeting();
    }

    @Nullable
    public byte[] getAttendeeReport() {
        return (byte[])this.backingStore.get("attendeeReport");
    }

    @Nullable
    public BroadcastMeetingSettings getBroadcastSettings() {
        return (BroadcastMeetingSettings)this.backingStore.get("broadcastSettings");
    }

    @Nullable
    public OffsetDateTime getCreationDateTime() {
        return (OffsetDateTime)this.backingStore.get("creationDateTime");
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Nullable
    public String getExternalId() {
        return (String)this.backingStore.get("externalId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("attendeeReport", n -> this.setAttendeeReport(n.getByteArrayValue()));
        deserializerMap.put("broadcastSettings", n -> this.setBroadcastSettings((BroadcastMeetingSettings)n.getObjectValue(BroadcastMeetingSettings::createFromDiscriminatorValue)));
        deserializerMap.put("creationDateTime", n -> this.setCreationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("externalId", n -> this.setExternalId(n.getStringValue()));
        deserializerMap.put("isBroadcast", n -> this.setIsBroadcast(n.getBooleanValue()));
        deserializerMap.put("meetingTemplateId", n -> this.setMeetingTemplateId(n.getStringValue()));
        deserializerMap.put("participants", n -> this.setParticipants((MeetingParticipants)n.getObjectValue(MeetingParticipants::createFromDiscriminatorValue)));
        deserializerMap.put("recordings", n -> this.setRecordings(n.getCollectionOfObjectValues(CallRecording::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("transcripts", n -> this.setTranscripts(n.getCollectionOfObjectValues(CallTranscript::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsBroadcast() {
        return (Boolean)this.backingStore.get("isBroadcast");
    }

    @Nullable
    public String getMeetingTemplateId() {
        return (String)this.backingStore.get("meetingTemplateId");
    }

    @Nullable
    public MeetingParticipants getParticipants() {
        return (MeetingParticipants)this.backingStore.get("participants");
    }

    @Nullable
    public List<CallRecording> getRecordings() {
        return (List)this.backingStore.get("recordings");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public List<CallTranscript> getTranscripts() {
        return (List)this.backingStore.get("transcripts");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeByteArrayValue("attendeeReport", this.getAttendeeReport());
        writer.writeObjectValue("broadcastSettings", (Parsable)this.getBroadcastSettings(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("creationDateTime", this.getCreationDateTime());
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeStringValue("externalId", this.getExternalId());
        writer.writeBooleanValue("isBroadcast", this.getIsBroadcast());
        writer.writeStringValue("meetingTemplateId", this.getMeetingTemplateId());
        writer.writeObjectValue("participants", (Parsable)this.getParticipants(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("recordings", this.getRecordings());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeCollectionOfObjectValues("transcripts", this.getTranscripts());
    }

    public void setAttendeeReport(@Nullable byte[] value) {
        this.backingStore.set("attendeeReport", (Object)value);
    }

    public void setBroadcastSettings(@Nullable BroadcastMeetingSettings value) {
        this.backingStore.set("broadcastSettings", (Object)value);
    }

    public void setCreationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("creationDateTime", (Object)value);
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setExternalId(@Nullable String value) {
        this.backingStore.set("externalId", (Object)value);
    }

    public void setIsBroadcast(@Nullable Boolean value) {
        this.backingStore.set("isBroadcast", (Object)value);
    }

    public void setMeetingTemplateId(@Nullable String value) {
        this.backingStore.set("meetingTemplateId", (Object)value);
    }

    public void setParticipants(@Nullable MeetingParticipants value) {
        this.backingStore.set("participants", (Object)value);
    }

    public void setRecordings(@Nullable List<CallRecording> value) {
        this.backingStore.set("recordings", value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setTranscripts(@Nullable List<CallTranscript> value) {
        this.backingStore.set("transcripts", value);
    }
}

