/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DlpActionInfo;
import com.microsoft.graph.models.ExecutionMode;
import com.microsoft.graph.models.PolicyLocation;
import com.microsoft.graph.models.PolicyTenantScope;
import com.microsoft.graph.models.PolicyUserScope;
import com.microsoft.graph.models.UserActivityTypes;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PolicyScopeBase
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PolicyScopeBase() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PolicyScopeBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.policyTenantScope": {
                    return new PolicyTenantScope();
                }
                case "#microsoft.graph.policyUserScope": {
                    return new PolicyUserScope();
                }
            }
        }
        return new PolicyScopeBase();
    }

    @Nullable
    public EnumSet<UserActivityTypes> getActivities() {
        return (EnumSet)this.backingStore.get("activities");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ExecutionMode getExecutionMode() {
        return (ExecutionMode)((Object)this.backingStore.get("executionMode"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("activities", n -> this.setActivities(n.getEnumSetValue(UserActivityTypes::forValue)));
        deserializerMap.put("executionMode", n -> this.setExecutionMode((ExecutionMode)n.getEnumValue(ExecutionMode::forValue)));
        deserializerMap.put("locations", n -> this.setLocations(n.getCollectionOfObjectValues(PolicyLocation::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("policyActions", n -> this.setPolicyActions(n.getCollectionOfObjectValues(DlpActionInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<PolicyLocation> getLocations() {
        return (List)this.backingStore.get("locations");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<DlpActionInfo> getPolicyActions() {
        return (List)this.backingStore.get("policyActions");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumSetValue("activities", this.getActivities());
        writer.writeEnumValue("executionMode", (Enum)this.getExecutionMode());
        writer.writeCollectionOfObjectValues("locations", this.getLocations());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("policyActions", this.getPolicyActions());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActivities(@Nullable EnumSet<UserActivityTypes> value) {
        this.backingStore.set("activities", value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExecutionMode(@Nullable ExecutionMode value) {
        this.backingStore.set("executionMode", (Object)value);
    }

    public void setLocations(@Nullable List<PolicyLocation> value) {
        this.backingStore.set("locations", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPolicyActions(@Nullable List<DlpActionInfo> value) {
        this.backingStore.set("policyActions", value);
    }
}

