/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PrinterLocation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PrintConnector
extends Entity
implements Parsable {
    @Nonnull
    public static PrintConnector createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PrintConnector();
    }

    @Nullable
    public String getAppVersion() {
        return (String)this.backingStore.get("appVersion");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appVersion", n -> this.setAppVersion(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("fullyQualifiedDomainName", n -> this.setFullyQualifiedDomainName(n.getStringValue()));
        deserializerMap.put("location", n -> this.setLocation((PrinterLocation)n.getObjectValue(PrinterLocation::createFromDiscriminatorValue)));
        deserializerMap.put("operatingSystem", n -> this.setOperatingSystem(n.getStringValue()));
        deserializerMap.put("registeredDateTime", n -> this.setRegisteredDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public String getFullyQualifiedDomainName() {
        return (String)this.backingStore.get("fullyQualifiedDomainName");
    }

    @Nullable
    public PrinterLocation getLocation() {
        return (PrinterLocation)this.backingStore.get("location");
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.backingStore.get("operatingSystem");
    }

    @Nullable
    public OffsetDateTime getRegisteredDateTime() {
        return (OffsetDateTime)this.backingStore.get("registeredDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("appVersion", this.getAppVersion());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("fullyQualifiedDomainName", this.getFullyQualifiedDomainName());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeStringValue("operatingSystem", this.getOperatingSystem());
        writer.writeOffsetDateTimeValue("registeredDateTime", this.getRegisteredDateTime());
    }

    public void setAppVersion(@Nullable String value) {
        this.backingStore.set("appVersion", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setFullyQualifiedDomainName(@Nullable String value) {
        this.backingStore.set("fullyQualifiedDomainName", (Object)value);
    }

    public void setLocation(@Nullable PrinterLocation value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.backingStore.set("operatingSystem", (Object)value);
    }

    public void setRegisteredDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("registeredDateTime", (Object)value);
    }
}

