/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ArtifactRestoreStatus;
import com.microsoft.graph.models.DestinationType;
import com.microsoft.graph.models.DriveRestoreArtifact;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.GranularMailboxRestoreArtifact;
import com.microsoft.graph.models.MailboxRestoreArtifact;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.RestorePoint;
import com.microsoft.graph.models.SiteRestoreArtifact;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RestoreArtifactBase
extends Entity
implements Parsable {
    @Nonnull
    public static RestoreArtifactBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.driveRestoreArtifact": {
                    return new DriveRestoreArtifact();
                }
                case "#microsoft.graph.granularMailboxRestoreArtifact": {
                    return new GranularMailboxRestoreArtifact();
                }
                case "#microsoft.graph.mailboxRestoreArtifact": {
                    return new MailboxRestoreArtifact();
                }
                case "#microsoft.graph.siteRestoreArtifact": {
                    return new SiteRestoreArtifact();
                }
            }
        }
        return new RestoreArtifactBase();
    }

    @Nullable
    public OffsetDateTime getCompletionDateTime() {
        return (OffsetDateTime)this.backingStore.get("completionDateTime");
    }

    @Nullable
    public DestinationType getDestinationType() {
        return (DestinationType)((Object)this.backingStore.get("destinationType"));
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("completionDateTime", n -> this.setCompletionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("destinationType", n -> this.setDestinationType((DestinationType)n.getEnumValue(DestinationType::forValue)));
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("restorePoint", n -> this.setRestorePoint((RestorePoint)n.getObjectValue(RestorePoint::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("status", n -> this.setStatus((ArtifactRestoreStatus)n.getEnumValue(ArtifactRestoreStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public RestorePoint getRestorePoint() {
        return (RestorePoint)this.backingStore.get("restorePoint");
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public ArtifactRestoreStatus getStatus() {
        return (ArtifactRestoreStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("completionDateTime", this.getCompletionDateTime());
        writer.writeEnumValue("destinationType", (Enum)this.getDestinationType());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeObjectValue("restorePoint", (Parsable)this.getRestorePoint(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCompletionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("completionDateTime", (Object)value);
    }

    public void setDestinationType(@Nullable DestinationType value) {
        this.backingStore.set("destinationType", (Object)value);
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setRestorePoint(@Nullable RestorePoint value) {
        this.backingStore.set("restorePoint", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStatus(@Nullable ArtifactRestoreStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

