/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SubjectSet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UnifiedApprovalStage
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UnifiedApprovalStage() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UnifiedApprovalStage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UnifiedApprovalStage();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Integer getApprovalStageTimeOutInDays() {
        return (Integer)this.backingStore.get("approvalStageTimeOutInDays");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<SubjectSet> getEscalationApprovers() {
        return (List)this.backingStore.get("escalationApprovers");
    }

    @Nullable
    public Integer getEscalationTimeInMinutes() {
        return (Integer)this.backingStore.get("escalationTimeInMinutes");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("approvalStageTimeOutInDays", n -> this.setApprovalStageTimeOutInDays(n.getIntegerValue()));
        deserializerMap.put("escalationApprovers", n -> this.setEscalationApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("escalationTimeInMinutes", n -> this.setEscalationTimeInMinutes(n.getIntegerValue()));
        deserializerMap.put("isApproverJustificationRequired", n -> this.setIsApproverJustificationRequired(n.getBooleanValue()));
        deserializerMap.put("isEscalationEnabled", n -> this.setIsEscalationEnabled(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("primaryApprovers", n -> this.setPrimaryApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsApproverJustificationRequired() {
        return (Boolean)this.backingStore.get("isApproverJustificationRequired");
    }

    @Nullable
    public Boolean getIsEscalationEnabled() {
        return (Boolean)this.backingStore.get("isEscalationEnabled");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<SubjectSet> getPrimaryApprovers() {
        return (List)this.backingStore.get("primaryApprovers");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("approvalStageTimeOutInDays", this.getApprovalStageTimeOutInDays());
        writer.writeCollectionOfObjectValues("escalationApprovers", this.getEscalationApprovers());
        writer.writeIntegerValue("escalationTimeInMinutes", this.getEscalationTimeInMinutes());
        writer.writeBooleanValue("isApproverJustificationRequired", this.getIsApproverJustificationRequired());
        writer.writeBooleanValue("isEscalationEnabled", this.getIsEscalationEnabled());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("primaryApprovers", this.getPrimaryApprovers());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApprovalStageTimeOutInDays(@Nullable Integer value) {
        this.backingStore.set("approvalStageTimeOutInDays", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEscalationApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("escalationApprovers", value);
    }

    public void setEscalationTimeInMinutes(@Nullable Integer value) {
        this.backingStore.set("escalationTimeInMinutes", (Object)value);
    }

    public void setIsApproverJustificationRequired(@Nullable Boolean value) {
        this.backingStore.set("isApproverJustificationRequired", (Object)value);
    }

    public void setIsEscalationEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEscalationEnabled", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrimaryApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("primaryApprovers", value);
    }
}

