/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.NetworkAdapter;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SensorSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SensorSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SensorSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SensorSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public List<String> getDomainControllerDnsNames() {
        return (List)this.backingStore.get("domainControllerDnsNames");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("domainControllerDnsNames", n -> this.setDomainControllerDnsNames(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("isDelayedDeploymentEnabled", n -> this.setIsDelayedDeploymentEnabled(n.getBooleanValue()));
        deserializerMap.put("networkAdapters", n -> this.setNetworkAdapters(n.getCollectionOfObjectValues(NetworkAdapter::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsDelayedDeploymentEnabled() {
        return (Boolean)this.backingStore.get("isDelayedDeploymentEnabled");
    }

    @Nullable
    public List<NetworkAdapter> getNetworkAdapters() {
        return (List)this.backingStore.get("networkAdapters");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfPrimitiveValues("domainControllerDnsNames", this.getDomainControllerDnsNames());
        writer.writeBooleanValue("isDelayedDeploymentEnabled", this.getIsDelayedDeploymentEnabled());
        writer.writeCollectionOfObjectValues("networkAdapters", this.getNetworkAdapters());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDomainControllerDnsNames(@Nullable List<String> value) {
        this.backingStore.set("domainControllerDnsNames", value);
    }

    public void setIsDelayedDeploymentEnabled(@Nullable Boolean value) {
        this.backingStore.set("isDelayedDeploymentEnabled", (Object)value);
    }

    public void setNetworkAdapters(@Nullable List<NetworkAdapter> value) {
        this.backingStore.set("networkAdapters", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

