/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AssignmentType;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.LearningCourseActivity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class LearningAssignment
extends LearningCourseActivity
implements Parsable {
    @Nonnull
    public static LearningAssignment createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new LearningAssignment();
    }

    @Nullable
    public OffsetDateTime getAssignedDateTime() {
        return (OffsetDateTime)this.backingStore.get("assignedDateTime");
    }

    @Nullable
    public String getAssignerUserId() {
        return (String)this.backingStore.get("assignerUserId");
    }

    @Nullable
    public AssignmentType getAssignmentType() {
        return (AssignmentType)((Object)this.backingStore.get("assignmentType"));
    }

    @Nullable
    public DateTimeTimeZone getDueDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("dueDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignedDateTime", n -> this.setAssignedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("assignerUserId", n -> this.setAssignerUserId(n.getStringValue()));
        deserializerMap.put("assignmentType", n -> this.setAssignmentType((AssignmentType)n.getEnumValue(AssignmentType::forValue)));
        deserializerMap.put("dueDateTime", n -> this.setDueDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("notes", n -> this.setNotes((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getNotes() {
        return (ItemBody)this.backingStore.get("notes");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("assignedDateTime", this.getAssignedDateTime());
        writer.writeStringValue("assignerUserId", this.getAssignerUserId());
        writer.writeEnumValue("assignmentType", (Enum)this.getAssignmentType());
        writer.writeObjectValue("dueDateTime", (Parsable)this.getDueDateTime(), new Parsable[0]);
        writer.writeObjectValue("notes", (Parsable)this.getNotes(), new Parsable[0]);
    }

    public void setAssignedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("assignedDateTime", (Object)value);
    }

    public void setAssignerUserId(@Nullable String value) {
        this.backingStore.set("assignerUserId", (Object)value);
    }

    public void setAssignmentType(@Nullable AssignmentType value) {
        this.backingStore.set("assignmentType", (Object)value);
    }

    public void setDueDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("dueDateTime", (Object)value);
    }

    public void setNotes(@Nullable ItemBody value) {
        this.backingStore.set("notes", (Object)value);
    }
}

