/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NumberColumn
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public NumberColumn() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static NumberColumn createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new NumberColumn();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDecimalPlaces() {
        return (String)this.backingStore.get("decimalPlaces");
    }

    @Nullable
    public String getDisplayAs() {
        return (String)this.backingStore.get("displayAs");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("decimalPlaces", n -> this.setDecimalPlaces(n.getStringValue()));
        deserializerMap.put("displayAs", n -> this.setDisplayAs(n.getStringValue()));
        deserializerMap.put("maximum", n -> this.setMaximum(n.getDoubleValue()));
        deserializerMap.put("minimum", n -> this.setMinimum(n.getDoubleValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Double getMaximum() {
        return (Double)this.backingStore.get("maximum");
    }

    @Nullable
    public Double getMinimum() {
        return (Double)this.backingStore.get("minimum");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("decimalPlaces", this.getDecimalPlaces());
        writer.writeStringValue("displayAs", this.getDisplayAs());
        writer.writeDoubleValue("maximum", this.getMaximum());
        writer.writeDoubleValue("minimum", this.getMinimum());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDecimalPlaces(@Nullable String value) {
        this.backingStore.set("decimalPlaces", (Object)value);
    }

    public void setDisplayAs(@Nullable String value) {
        this.backingStore.set("displayAs", (Object)value);
    }

    public void setMaximum(@Nullable Double value) {
        this.backingStore.set("maximum", (Object)value);
    }

    public void setMinimum(@Nullable Double value) {
        this.backingStore.set("minimum", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

