/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.IMultipleAccountPublicClientApplication;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.PoPAuthenticationScheme;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import java.util.Date;
import java.util.List;

public interface IPublicClientApplication {
    public void acquireToken(@NonNull Activity var1, @NonNull String[] var2, @NonNull AuthenticationCallback var3);

    public void acquireToken(@NonNull AcquireTokenParameters var1);

    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters var1);

    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters var1) throws InterruptedException, MsalException;

    public void acquireTokenWithDeviceCode(@NonNull String[] var1, @NonNull DeviceCodeFlowCallback var2);

    public PublicClientApplicationConfiguration getConfiguration();

    public boolean isSharedDevice();

    @NonNull
    public String generateSignedHttpRequest(@NonNull IAccount var1, @NonNull PoPAuthenticationScheme var2) throws MsalException;

    public void generateSignedHttpRequest(@NonNull IAccount var1, @NonNull PoPAuthenticationScheme var2, @NonNull SignedHttpRequestRequestCallback var3);

    public static interface DeviceCodeFlowCallback {
        public void onUserCodeReceived(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull Date var4);

        public void onTokenReceived(@NonNull AuthenticationResult var1);

        public void onError(@NonNull MsalException var1);
    }

    public static interface IMultipleAccountApplicationCreatedListener {
        public void onCreated(IMultipleAccountPublicClientApplication var1);

        public void onError(MsalException var1);
    }

    public static interface ISingleAccountApplicationCreatedListener {
        public void onCreated(ISingleAccountPublicClientApplication var1);

        public void onError(MsalException var1);
    }

    public static interface ApplicationCreatedListener {
        public void onCreated(IPublicClientApplication var1);

        public void onError(MsalException var1);
    }

    public static interface LoadAccountsCallback
    extends TaskCompletedCallbackWithError<List<IAccount>, MsalException> {
        public void onTaskCompleted(List<IAccount> var1);

        public void onError(MsalException var1);
    }

    public static interface SignedHttpRequestRequestCallback
    extends TaskCompletedCallbackWithError<String, MsalException> {
        public void onTaskCompleted(String var1);

        public void onError(MsalException var1);
    }
}

