/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AadAuthorityAudience;
import com.microsoft.identity.client.AuthenticationScheme;
import com.microsoft.identity.client.AzureCloudInstance;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.dto.AccountRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class TokenParameters {
    private List<String> mScopes;
    private IAccount mAccount;
    private String mAuthority;
    private ClaimsRequest mClaimsRequest;
    private AccountRecord mAccountRecord;
    private AuthenticationScheme mAuthenticationScheme;
    private String mCorrelationId;

    protected TokenParameters(@NonNull Builder builder) {
        this.mAccount = builder.mAccount;
        this.mAuthority = builder.mAuthority;
        this.mClaimsRequest = builder.mClaimsRequest;
        this.mScopes = builder.mScopes;
        this.mAuthenticationScheme = builder.mAuthenticationScheme;
        this.mCorrelationId = builder.mCorrelationId;
    }

    @NonNull
    public AuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    public List<String> getScopes() {
        return this.mScopes;
    }

    void setScopes(List<String> scopes) {
        this.mScopes = scopes;
    }

    public IAccount getAccount() {
        return this.mAccount;
    }

    void setAccount(IAccount account) {
        this.mAccount = account;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public ClaimsRequest getClaimsRequest() {
        return this.mClaimsRequest;
    }

    void setAccountRecord(AccountRecord record) {
        this.mAccountRecord = record;
    }

    public AccountRecord getAccountRecord() {
        return this.mAccountRecord;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private List<String> mScopes;
        private IAccount mAccount;
        private String mAuthority;
        private ClaimsRequest mClaimsRequest;
        private AuthenticationScheme mAuthenticationScheme;
        private String mCorrelationId;

        public B withAuthenticationScheme(@NonNull AuthenticationScheme scheme) {
            this.mAuthenticationScheme = scheme;
            return this.self();
        }

        public B withScopes(List<String> scopes) {
            if (null != this.mScopes) {
                throw new IllegalArgumentException("Scopes is already set.");
            }
            if (null == scopes || scopes.isEmpty()) {
                throw new IllegalArgumentException("Empty scopes list.");
            }
            this.mScopes = scopes;
            return this.self();
        }

        public B forAccount(IAccount account) {
            this.mAccount = account;
            return this.self();
        }

        public B fromAuthority(String authorityUrl) {
            this.mAuthority = authorityUrl;
            return this.self();
        }

        public B fromAuthority(@NonNull AzureCloudInstance cloudInstance, @NonNull AadAuthorityAudience audience, @Nullable String tenant) {
            if (!TextUtils.isEmpty((CharSequence)tenant)) {
                if (audience != AadAuthorityAudience.AzureAdMyOrg) {
                    throw new IllegalArgumentException("Audience must be " + (Object)((Object)AadAuthorityAudience.AzureAdMyOrg) + " when tenant is specified");
                }
                return this.fromAuthority(cloudInstance, tenant);
            }
            if (audience == AadAuthorityAudience.AzureAdMyOrg) {
                if (TextUtils.isEmpty((CharSequence)tenant)) {
                    throw new IllegalArgumentException("Tenant must be specified when the audience is " + (Object)((Object)audience));
                }
                this.mAuthority = cloudInstance.getCloudInstanceUri() + "/" + tenant;
                return this.self();
            }
            this.mAuthority = cloudInstance.getCloudInstanceUri() + "/" + audience.getAudienceValue();
            return this.self();
        }

        public B fromAuthority(@NonNull AzureCloudInstance cloudInstance, @NonNull AadAuthorityAudience audience) {
            return this.fromAuthority(cloudInstance, audience, null);
        }

        public B fromAuthority(@NonNull AzureCloudInstance cloudInstance, @NonNull String tenant) {
            this.mAuthority = cloudInstance.getCloudInstanceUri() + "/" + tenant;
            return this.self();
        }

        public B withClaims(ClaimsRequest claimsRequest) {
            this.mClaimsRequest = claimsRequest;
            return this.self();
        }

        public B withResource(final String resource) {
            if (null != this.mScopes) {
                throw new IllegalArgumentException("Scopes is already set. Scopes and resources cannot be combined in a single request.");
            }
            if (StringUtil.isEmpty((String)resource)) {
                throw new IllegalArgumentException("Empty resource string.");
            }
            this.mScopes = new ArrayList<String>(){
                {
                    this.add(resource.trim() + "/.default");
                }
            };
            return this.self();
        }

        public B withCorrelationId(@NonNull UUID correlationId) {
            this.mCorrelationId = correlationId.toString();
            return this.self();
        }

        public abstract B self();

        public abstract TokenParameters build();
    }
}

