/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.microsoft.identity.common.internal.cache.ISimpleCache;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;

public abstract class SharedPreferencesSimpleCacheImpl<T>
implements ISimpleCache<T> {
    private static final String TAG = SharedPreferencesSimpleCacheImpl.class.getSimpleName();
    private static final String EMPTY_ARRAY = "[]";
    private final SharedPreferences mSharedPrefs;
    private final String mKeySingleEntry;
    private final Gson mGson = new Gson();

    public SharedPreferencesSimpleCacheImpl(@NonNull Context context, @NonNull String prefsName, @NonNull String singleKey) {
        Logger.verbose(TAG + "::ctor", "Init");
        this.mSharedPrefs = context.getSharedPreferences(prefsName, 0);
        this.mKeySingleEntry = singleKey;
    }

    protected abstract Type getListTypeToken();

    @Override
    public boolean insert(T t) {
        String methodName = ":insert";
        HashSet<T> allMetadata = new HashSet<T>(this.getAll());
        Logger.verbose(TAG + ":insert", "Existing metadata contained [" + allMetadata.size() + "] elements.");
        allMetadata.add(t);
        Logger.verbose(TAG + ":insert", "New metadata set size: [" + allMetadata.size() + "]");
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(TAG + ":insert", "Writing cache entry.");
        boolean success = this.mSharedPrefs.edit().putString(this.mKeySingleEntry, json).commit();
        if (success) {
            Logger.verbose(TAG + ":insert", "Cache successfully updated.");
        } else {
            Logger.warn(TAG + ":insert", "Error writing to cache.");
        }
        return success;
    }

    @Override
    public boolean remove(T t) {
        String methodName = ":remove";
        HashSet<T> allMetadata = new HashSet<T>(this.getAll());
        Logger.verbose(TAG + ":remove", "Existing metadata contained [" + allMetadata.size() + "] elements.");
        boolean removed = allMetadata.remove(t);
        Logger.verbose(TAG + ":remove", "New metadata set size: [" + allMetadata.size() + "]");
        if (!removed) {
            Logger.warn(TAG + ":remove", "Nothing to delete -- cache entry is missing!");
            return true;
        }
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(TAG + ":remove", "Writing new cache values...");
        boolean written = this.mSharedPrefs.edit().putString(this.mKeySingleEntry, json).commit();
        Logger.verbose(TAG + ":remove", "Updated cache contents written? [" + written + "]");
        return written;
    }

    @Override
    public List<T> getAll() {
        String methodName = ":getAll";
        String jsonList = this.mSharedPrefs.getString(this.mKeySingleEntry, EMPTY_ARRAY);
        Type listType = this.getListTypeToken();
        List result = (List)this.mGson.fromJson(jsonList, listType);
        Logger.verbose(TAG + ":getAll", "Found [" + result.size() + "] cache entries.");
        return result;
    }

    @Override
    public boolean clear() {
        String methodName = ":clear";
        boolean cleared = this.mSharedPrefs.edit().clear().commit();
        if (!cleared) {
            Logger.warn(TAG + ":clear", "Failed to clear cache.");
        } else {
            Logger.verbose(TAG + ":clear", "Cache successfully cleared.");
        }
        return cleared;
    }
}

