/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.DeviceCodeFlowCommandCallback;
import com.microsoft.identity.common.internal.commands.TokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.logging.Logger;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DeviceCodeFlowCommand
extends TokenCommand {
    private static final String TAG = DeviceCodeFlowCommand.class.getSimpleName();

    public DeviceCodeFlowCommand(@NonNull DeviceCodeFlowCommandParameters parameters, @NonNull BaseController controller, @NonNull DeviceCodeFlowCommandCallback callback, @NonNull String publicApiId) {
        super((TokenCommandParameters)parameters, controller, (CommandCallback)callback, publicApiId);
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodName = ":execute";
        Logger.verbose(TAG + ":execute", "Device Code Flow command initiating...");
        BaseController controller = this.getDefaultController();
        DeviceCodeFlowCommandParameters commandParameters = (DeviceCodeFlowCommandParameters)this.getParameters();
        AuthorizationResult authorizationResult = controller.deviceCodeFlowAuthRequest(commandParameters);
        MicrosoftStsAuthorizationResponse authorizationResponse = (MicrosoftStsAuthorizationResponse)authorizationResult.getAuthorizationResponse();
        Date expiredDate = new Date();
        try {
            long expiredInInMilliseconds = TimeUnit.SECONDS.toMillis(Long.parseLong(authorizationResponse.getExpiresIn()));
            expiredDate.setTime(expiredDate.getTime() + expiredInInMilliseconds);
        }
        catch (NumberFormatException e) {
            Logger.error(TAG + ":execute", "Failed to parse authorizationResponse.getExpiresIn()", e);
        }
        DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = (DeviceCodeFlowCommandCallback)this.getCallback();
        deviceCodeFlowCommandCallback.onUserCodeReceived(authorizationResponse.getVerificationUri(), authorizationResponse.getUserCode(), authorizationResponse.getMessage(), expiredDate);
        AcquireTokenResult tokenResult = controller.acquireDeviceCodeFlowToken(authorizationResult, commandParameters);
        Logger.verbose(TAG + ":execute", "Device Code Flow command exiting with token...");
        return tokenResult;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    void notify(int requestCode, int resultCode, Intent data) {
        this.getDefaultController().completeAcquireToken(requestCode, resultCode, data);
    }
}

