/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;

public class BrokerOperationExecutor {
    private static final String TAG = BrokerOperationExecutor.class.getSimpleName();
    private final List<IIpcStrategy> mStrategies;

    public BrokerOperationExecutor(@NonNull List<IIpcStrategy> strategies) {
        this.mStrategies = strategies;
    }

    public <T extends CommandParameters, U> U execute(@Nullable T parameters, @NonNull BrokerOperation<U> operation) throws BaseException {
        String methodName = ":execute";
        this.emitOperationStartEvent(parameters, operation);
        if (this.mStrategies.size() == 0) {
            ClientException exception = new ClientException("Failed to bind the service in broker app", "No strategies can be used to connect to the broker.");
            this.emitOperationFailureEvent(operation, exception);
            throw exception;
        }
        ArrayList<BrokerCommunicationException> communicationExceptionStack = new ArrayList<BrokerCommunicationException>();
        for (IIpcStrategy strategy : this.mStrategies) {
            try {
                U result = this.performStrategy(strategy, operation);
                this.emitOperationSuccessEvent(operation, result);
                return result;
            }
            catch (BrokerCommunicationException communicationException) {
                communicationExceptionStack.add(communicationException);
            }
            catch (BaseException exception) {
                this.emitOperationFailureEvent(operation, exception);
                throw exception;
            }
        }
        ClientException exception = new ClientException("Failed to bind the service in broker app", "Unable to connect to the broker. Please refer to MSAL/Broker logs or suppressed exception (API 19+) for more details.");
        for (BrokerCommunicationException e : communicationExceptionStack) {
            Logger.error(TAG + ":execute", e.getMessage(), e);
            if (Build.VERSION.SDK_INT < 19) continue;
            exception.addSuppressed(e);
        }
        this.emitOperationFailureEvent(operation, exception);
        throw exception;
    }

    private <T extends CommandParameters, U> void emitOperationStartEvent(@Nullable T parameters, @NonNull BrokerOperation<U> operation) {
        if (operation.getTelemetryApiId() != null) {
            Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId(operation.getTelemetryApiId()));
        }
    }

    private <U> void emitOperationSuccessEvent(@NonNull BrokerOperation<U> operation, U result) {
        if (operation.getTelemetryApiId() != null) {
            ApiEndEvent successEvent = new ApiEndEvent().putApiId(operation.getTelemetryApiId()).isApiCallSuccessful(Boolean.TRUE);
            operation.putValueInSuccessEvent(successEvent, result);
            Telemetry.emit(successEvent);
        }
    }

    private <U> void emitOperationFailureEvent(@NonNull BrokerOperation<U> operation, BaseException exception) {
        if (operation.getTelemetryApiId() != null) {
            Telemetry.emit(new ApiEndEvent().putException(exception).putApiId(operation.getTelemetryApiId()));
        }
    }

    private <T> T performStrategy(@NonNull IIpcStrategy strategy, @NonNull BrokerOperation<T> operation) throws BaseException {
        com.microsoft.identity.common.internal.logging.Logger.info(TAG + operation.getMethodName(), "Executing with IIpcStrategy: " + strategy.getClass().getSimpleName());
        operation.performPrerequisites(strategy);
        BrokerOperationBundle brokerOperationBundle = operation.getBundle();
        Bundle resultBundle = strategy.communicateToBroker(brokerOperationBundle);
        return operation.extractResultBundle(resultBundle);
    }

    public static interface BrokerOperation<T> {
        public void performPrerequisites(@NonNull IIpcStrategy var1) throws BaseException;

        @NonNull
        public BrokerOperationBundle getBundle();

        @NonNull
        public T extractResultBundle(@Nullable Bundle var1) throws BaseException;

        @NonNull
        public String getMethodName();

        @Nullable
        public String getTelemetryApiId();

        public void putValueInSuccessEvent(@NonNull ApiEndEvent var1, @NonNull T var2);
    }
}

