/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import java.util.UUID;

class TelemetryPropertiesCache {
    private static final String SHARED_PREFS_NAME = "com.microsoft.common.telemetry-properties";
    private static final String DEVICE_ID_GUID = "device_id_guid";
    private final SharedPreferencesFileManager mSharedPrefs;

    TelemetryPropertiesCache(@NonNull Context context) {
        this.mSharedPrefs = SharedPreferencesFileManager.getSharedPreferences(context, SHARED_PREFS_NAME, -1, null);
    }

    synchronized String getOrCreateRandomStableDeviceId() {
        String deviceId = this.mSharedPrefs.getString(DEVICE_ID_GUID);
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = UUID.randomUUID().toString();
            this.mSharedPrefs.putString(DEVICE_ID_GUID, deviceId);
        }
        return deviceId;
    }
}

