/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.logging.Logger;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public final class StringUtil {
    private static final String TAG = StringUtil.class.getSimpleName();

    private StringUtil() {
    }

    public static boolean isEmpty(String message) {
        return message == null || message.trim().length() == 0;
    }

    public static boolean containsSubString(String str, String substr) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return str.contains(substr);
    }

    public static String convertSetToString(Set<String> inputSet, String delimiter) {
        if (inputSet == null || inputSet.isEmpty() || delimiter == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = inputSet.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(delimiter);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String join(char delimiter, @NonNull Iterable<String> toJoin) {
        StringBuilder builder = new StringBuilder();
        char tempDelimiter = '\u0000';
        for (String s : toJoin) {
            if (tempDelimiter != '\u0000') {
                builder.append(tempDelimiter);
            }
            tempDelimiter = delimiter;
            builder.append(s);
        }
        return builder.toString();
    }

    public static Pair<String, String> getTenantInfo(@NonNull String homeAccountId) {
        int EXPECTED_LENGTH = 2;
        boolean INDEX_UID = false;
        boolean INDEX_UTID = true;
        String[] uidUtidArray = homeAccountId.split("\\.");
        String uid = null;
        String utid = null;
        if (2 == uidUtidArray.length && !StringExtensions.isNullOrBlank(uidUtidArray[0]) && !StringExtensions.isNullOrBlank(uidUtidArray[1])) {
            uid = uidUtidArray[0];
            utid = uidUtidArray[1];
        } else {
            Logger.warn(TAG, "We had a home account id that could not be split correctly, We expected it to split into 2 parts but instead we had " + uidUtidArray.length + " when splitting the string on dot ('.')");
            Logger.warnPII(TAG, "We had a home account id that could not be split correctly, Its value was: '" + homeAccountId + "', and we expected it to split into " + 2 + " parts but instead we had " + uidUtidArray.length + " when splitting the string on dot ('.')");
        }
        return new Pair((Object)uid, (Object)utid);
    }

    public static int compareSemanticVersion(@NonNull String thisVersion, @Nullable String thatVersion) {
        if (thatVersion == null) {
            return 1;
        }
        String[] thisParts = thisVersion.split("\\.");
        String[] thatParts = thatVersion.split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isFirstVersionSmallerOrEqual(@NonNull String first, @Nullable String second) {
        return StringUtil.compareSemanticVersion(first, second) <= 0;
    }

    public static boolean isFirstVersionLargerOrEqual(@NonNull String first, @Nullable String second) {
        return StringUtil.compareSemanticVersion(first, second) >= 0;
    }

    public static int countMatches(@NonNull String str, @Nullable String subString) {
        int count = 0;
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(subString)) {
            return count;
        }
        for (int i = 0; i <= str.length() - subString.length(); ++i) {
            if (!str.substring(i, i + subString.length()).equalsIgnoreCase(subString)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isUuid(@NonNull String inputString) {
        try {
            UUID.fromString(inputString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean equalsIgnoreCase(@Nullable String one, @Nullable String two) {
        return one == two || one != null && one.equalsIgnoreCase(two);
    }

    public static boolean equalsIgnoreCaseTrim(@Nullable String one, @Nullable String two) {
        return one == two || two != null && StringUtil.equalsIgnoreCase(one, two.trim());
    }

    public static boolean equalsIgnoreCaseTrimBoth(@Nullable String one, @Nullable String two) {
        return StringUtil.equalsIgnoreCaseTrim(null != one ? one.trim() : one, two);
    }
}

