/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.migration;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallback;
import com.microsoft.identity.common.logging.Logger;
import com.microsoft.identity.common.migration.IMigrationOperationResult;
import com.microsoft.identity.common.migration.ISharedPrefsFileManagerReencrypter;
import com.microsoft.identity.common.migration.MigrationOperationResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultSharedPrefsFileManagerReencrypter
implements ISharedPrefsFileManagerReencrypter {
    private static final String TAG = DefaultSharedPrefsFileManagerReencrypter.class.getSimpleName();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public IMigrationOperationResult reencrypt(@NonNull ISharedPreferencesFileManager fileManager, final @NonNull ISharedPrefsFileManagerReencrypter.IStringEncrypter encrypter, final @NonNull ISharedPrefsFileManagerReencrypter.IStringDecrypter decrypter, @NonNull ISharedPrefsFileManagerReencrypter.ReencryptionParams params) {
        String methodName = ":reencrypt (sync)";
        HashMap<String, String> cacheEntries = new HashMap<String, String>(fileManager.getAll());
        Logger.verbose(TAG + ":reencrypt (sync)", "Attempting to migrate cache entries: " + cacheEntries.size());
        MigrationOperationResult result = new MigrationOperationResult();
        result.setCountOfTotalRecords(cacheEntries.size());
        HashSet<String> keysMarkedForRemoval = new HashSet<String>();
        AtomicBoolean shouldAbort = new AtomicBoolean(false);
        HashSet<String> skipKeys = new HashSet<String>();
        this.applyCacheMutation(cacheEntries, new Callable<Map.Entry<String, String>>(){

            @Override
            public void call(Map.Entry<String, String> entry) throws Exception {
                String decryptedText = decrypter.decrypt(entry.getValue());
                entry.setValue(decryptedText);
            }
        }, result, params, keysMarkedForRemoval, skipKeys, shouldAbort);
        this.clearEntriesMarkedForRemoval(fileManager, cacheEntries, keysMarkedForRemoval);
        if (shouldAbort.get()) {
            Logger.info(TAG + ":reencrypt (sync)", "Aborting after decrypt.");
            return result;
        }
        this.applyCacheMutation(cacheEntries, new Callable<Map.Entry<String, String>>(){

            @Override
            public void call(Map.Entry<String, String> entry) throws Exception {
                String reencryptedText = encrypter.encrypt(entry.getValue());
                entry.setValue(reencryptedText);
            }
        }, result, params, keysMarkedForRemoval, skipKeys, shouldAbort);
        this.clearEntriesMarkedForRemoval(fileManager, cacheEntries, keysMarkedForRemoval);
        if (shouldAbort.get()) {
            Logger.info(TAG + ":reencrypt (sync)", "Aborting after reencrypt.");
            return result;
        }
        Logger.info(TAG + ":reencrypt (sync)", "Writing reencrypted cache entries.");
        for (Map.Entry cacheEntry : cacheEntries.entrySet()) {
            fileManager.putString((String)cacheEntry.getKey(), (String)cacheEntry.getValue());
        }
        return result;
    }

    private void applyCacheMutation(@NonNull Map<String, String> cacheEntries, @NonNull Callable<Map.Entry<String, String>> callable, @NonNull MigrationOperationResult inputResult, @NonNull ISharedPrefsFileManagerReencrypter.ReencryptionParams params, @NonNull Set<String> keysMarkedForRemoval, @NonNull Set<String> skipKeys, @NonNull AtomicBoolean shouldAbort) {
        String methodName = ":applyCacheMutation";
        for (Map.Entry<String, String> cacheEntry : cacheEntries.entrySet()) {
            try {
                if (skipKeys.contains(cacheEntry.getKey())) {
                    Logger.warn(TAG + ":applyCacheMutation", "Skipping entry.");
                    continue;
                }
                callable.call(cacheEntry);
            }
            catch (Exception e) {
                Logger.error(TAG + ":applyCacheMutation", "Error during mutation", e);
                Logger.errorPII(TAG + ":applyCacheMutation", "Failed key: " + cacheEntry.getKey(), e);
                inputResult.addFailure(e);
                skipKeys.add(cacheEntry.getKey());
                if (params.eraseEntryOnError()) {
                    Logger.warn(TAG + ":applyCacheMutation", "Marking key for removal.");
                    keysMarkedForRemoval.add(cacheEntry.getKey());
                }
                if (params.eraseAllOnError()) {
                    Logger.warn(TAG + ":applyCacheMutation", "Marking all keys for removal.");
                    keysMarkedForRemoval.addAll(cacheEntries.keySet());
                    shouldAbort.set(true);
                    break;
                }
                if (!params.abortOnError()) continue;
                shouldAbort.set(true);
                break;
            }
        }
    }

    private void clearEntriesMarkedForRemoval(@NonNull ISharedPreferencesFileManager fileManager, @NonNull Map<String, String> cacheEntries, @NonNull Set<String> keysMarkedForRemoval) {
        String methodName = ":clearEntriesMarkedForRemoval";
        Logger.warn(TAG + ":clearEntriesMarkedForRemoval", "Removing entries marked for removal");
        for (String removedKey : keysMarkedForRemoval) {
            cacheEntries.remove(removedKey);
            fileManager.remove(removedKey);
        }
    }

    @Override
    public void reencryptAsync(final @NonNull ISharedPreferencesFileManager fileManager, final @NonNull ISharedPrefsFileManagerReencrypter.IStringEncrypter encrypter, final @NonNull ISharedPrefsFileManagerReencrypter.IStringDecrypter decrypter, final @NonNull ISharedPrefsFileManagerReencrypter.ReencryptionParams params, final @NonNull TaskCompletedCallback<IMigrationOperationResult> callback) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onTaskCompleted(DefaultSharedPrefsFileManagerReencrypter.this.reencrypt(fileManager, encrypter, decrypter, params));
            }
        });
    }

    private static interface Callable<T> {
        public void call(T var1) throws Exception;
    }
}

