/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.cache.MapBackedPreferencesManager;
import com.microsoft.identity.common.java.commands.ICommand;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.IAndroidKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.providers.oauth2.IStateGenerator;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.java.util.ported.InMemoryStorage;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class SettablePlatformComponents
implements IPlatformComponents {
    public static final IDevicePopManager NONFUNCTIONAL_POP_MANAGER = new IDevicePopManager(){

        @Override
        public boolean asymmetricKeyExists() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asymmetricKeyExists(String thumbprint) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAsymmetricKeyThumbprint() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void generateAsymmetricKey(TaskCompletedCallbackWithError<String, ClientException> callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String generateAsymmetricKey() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getAsymmetricKeyCreationDate() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean clearAsymmetricKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRequestConfirmation() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getRequestConfirmation(TaskCompletedCallbackWithError<String, ClientException> callback) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sign(SigningAlgorithm alg, String input) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] sign(@NonNull SigningAlgorithm alg, byte[] input) throws ClientException {
            if (alg == null) {
                throw new NullPointerException("alg is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean verify(SigningAlgorithm alg, String plainText, String signatureStr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean verify(@NonNull SigningAlgorithm alg, byte[] plainText, byte[] signatureBytes) {
            if (alg == null) {
                throw new NullPointerException("alg is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public String encrypt(IDevicePopManager.Cipher cipher, String plaintext) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] encrypt(@NonNull IDevicePopManager.Cipher cipher, @NonNull byte[] plaintext) throws ClientException {
            if (cipher == null) {
                throw new NullPointerException("cipher is marked non-null but is null");
            }
            if (plaintext == null) {
                throw new NullPointerException("plaintext is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public String decrypt(IDevicePopManager.Cipher cipher, String ciphertext) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] decrypt(@NonNull IDevicePopManager.Cipher cipher, byte[] ciphertext) throws ClientException {
            if (cipher == null) {
                throw new NullPointerException("cipher is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public SecureHardwareState getSecureHardwareState() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPublicKey(IDevicePopManager.PublicKeyFormat format) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Certificate[] getCertificateChain() throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mintSignedAccessToken(String httpMethod, long timestamp, URL requestUrl, String accessToken, String nonce) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mintSignedAccessToken(String httpMethod, long timestamp, URL requestUrl, String accessToken, String nonce, String clientClaims) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mintSignedHttpRequest(String httpMethod, long timestamp, URL requestUrl, String nonce, String clientClaims) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IAndroidKeyStoreKeyManager<KeyStore.PrivateKeyEntry> getKeyManager() {
            throw new UnsupportedOperationException();
        }
    };
    private final IKeyAccessor mStorageEncryptionManager;
    private final IClockSkewManager mClockSkewManager = new IClockSkewManager(){

        @Override
        public void onTimestampReceived(long referenceTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSkewMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date toClientTime(long referenceTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date toReferenceTime(long clientTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getCurrentClientTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getAdjustedReferenceTime() {
            throw new UnsupportedOperationException();
        }
    };
    private final IDevicePopManager mDefaultDevicePopManager = NONFUNCTIONAL_POP_MANAGER;
    private final IDevicePopManager mDevicePopManager;
    private final Map<String, INameValueStorage<?>> mStores = new ConcurrentHashMap();
    private final Map<String, INameValueStorage<?>> mEncryptedStores = new ConcurrentHashMap();
    private final Map<String, IMultiTypeNameValueStorage> mEncryptedFileStores = new ConcurrentHashMap<String, IMultiTypeNameValueStorage>();
    private final Map<String, IMultiTypeNameValueStorage> mFileStores = new ConcurrentHashMap<String, IMultiTypeNameValueStorage>();
    private final IAuthorizationStrategyFactory mAuthorizationStrategyFactory;
    private final IStateGenerator mStateGenerator = new IStateGenerator(){

        @Override
        @NonNull
        public String generate() {
            throw new UnsupportedOperationException();
        }
    };
    private final IPlatformUtil mPlatformUtil = new IPlatformUtil(){

        @Override
        public List<BrowserDescriptor> getBrowserSafeListForBroker() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getInstalledCompanyPortalVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void throwIfNetworkNotAvailable(boolean performPowerOptimizationCheck) throws ClientException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeCookiesFromWebView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidCallingApp(@NonNull String redirectUri, @NonNull String packageName) {
            if (redirectUri == null) {
                throw new NullPointerException("redirectUri is marked non-null but is null");
            }
            if (packageName == null) {
                throw new NullPointerException("packageName is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getEnrollmentId(@NonNull String userId, @NonNull String packageName) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            if (packageName == null) {
                throw new NullPointerException("packageName is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void onReturnCommandResult(@NonNull ICommand<?> command) {
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public long getNanosecondTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void postCommandResult(@NonNull Runnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("runnable is marked non-null but is null");
            }
            throw new UnsupportedOperationException();
        }
    };

    @Override
    @NonNull
    public IKeyAccessor getStorageEncryptionManager() {
        return null;
    }

    @Override
    @NonNull
    public IClockSkewManager getClockSkewManager() {
        return null;
    }

    @Override
    @NonNull
    public IDevicePopManager getDevicePopManager(@Nullable String alias) throws ClientException {
        return this.mDevicePopManager;
    }

    @Override
    public synchronized <T> INameValueStorage<T> getNameValueStore(String storeName, Class<T> clazz) {
        INameValueStorage<?> ret = this.mStores.get(storeName);
        if (ret == null) {
            this.mStores.put(storeName, new InMemoryStorage());
            ret = this.mStores.get(storeName);
        }
        return ret;
    }

    @Override
    public <T> INameValueStorage<T> getEncryptedNameValueStore(String storeName, IKeyAccessor helper, Class<T> clazz) {
        INameValueStorage<?> ret = this.mEncryptedStores.get(storeName);
        if (ret == null) {
            this.mEncryptedStores.put(storeName, new InMemoryStorage());
            ret = this.mEncryptedStores.get(storeName);
        }
        return ret;
    }

    @Override
    public synchronized IMultiTypeNameValueStorage getEncryptedFileStore(String storeName, IKeyAccessor helper) {
        IMultiTypeNameValueStorage ret = this.mEncryptedFileStores.get(storeName);
        if (ret == null) {
            this.mEncryptedFileStores.put(storeName, MapBackedPreferencesManager.builder().name(storeName).build());
            ret = this.mEncryptedFileStores.get(storeName);
        }
        return ret;
    }

    @Override
    public IMultiTypeNameValueStorage getFileStore(String storeName) {
        IMultiTypeNameValueStorage ret = this.mFileStores.get(storeName);
        if (ret == null) {
            this.mFileStores.put(storeName, MapBackedPreferencesManager.builder().name(storeName).build());
            ret = this.mFileStores.get(storeName);
        }
        return ret;
    }

    private static IKeyAccessor $default$storageEncryptionManager() {
        return new IKeyAccessor(){

            @Override
            public byte[] encrypt(byte[] plaintext) throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] decrypt(byte[] ciphertext) throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] sign(byte[] text) throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean verify(byte[] text, byte[] signature) throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getThumbprint() throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Certificate[] getCertificateChain() throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public SecureHardwareState getSecureHardwareState() throws ClientException {
                throw new UnsupportedOperationException();
            }

            @Override
            public IKeyAccessor generateDerivedKey(byte[] label, byte[] ctx, CryptoSuite suite) throws ClientException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static IDevicePopManager $default$devicePopManager() {
        return NONFUNCTIONAL_POP_MANAGER;
    }

    private static IAuthorizationStrategyFactory $default$authorizationStrategyFactory() {
        return new IAuthorizationStrategyFactory(){

            public IAuthorizationStrategy getAuthorizationStrategy(@NonNull InteractiveTokenCommandParameters parameters) {
                if (parameters == null) {
                    throw new NullPointerException("parameters is marked non-null but is null");
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    SettablePlatformComponents(IKeyAccessor storageEncryptionManager, IDevicePopManager devicePopManager, IAuthorizationStrategyFactory authorizationStrategyFactory) {
        this.mStorageEncryptionManager = storageEncryptionManager;
        this.mDevicePopManager = devicePopManager;
        this.mAuthorizationStrategyFactory = authorizationStrategyFactory;
    }

    public static SettablePlatformComponentsBuilder builder() {
        return new SettablePlatformComponentsBuilder();
    }

    @Override
    public IDevicePopManager getDefaultDevicePopManager() {
        return this.mDefaultDevicePopManager;
    }

    public Map<String, INameValueStorage<?>> getStores() {
        return this.mStores;
    }

    public Map<String, INameValueStorage<?>> getEncryptedStores() {
        return this.mEncryptedStores;
    }

    public Map<String, IMultiTypeNameValueStorage> getEncryptedFileStores() {
        return this.mEncryptedFileStores;
    }

    public Map<String, IMultiTypeNameValueStorage> getFileStores() {
        return this.mFileStores;
    }

    @Override
    public IAuthorizationStrategyFactory getAuthorizationStrategyFactory() {
        return this.mAuthorizationStrategyFactory;
    }

    @Override
    public IStateGenerator getStateGenerator() {
        return this.mStateGenerator;
    }

    @Override
    public IPlatformUtil getPlatformUtil() {
        return this.mPlatformUtil;
    }

    public IDevicePopManager getDevicePopManager() {
        return this.mDevicePopManager;
    }

    public static class SettablePlatformComponentsBuilder {
        private boolean storageEncryptionManager$set;
        private IKeyAccessor storageEncryptionManager$value;
        private boolean devicePopManager$set;
        private IDevicePopManager devicePopManager$value;
        private boolean authorizationStrategyFactory$set;
        private IAuthorizationStrategyFactory authorizationStrategyFactory$value;

        SettablePlatformComponentsBuilder() {
        }

        public SettablePlatformComponentsBuilder storageEncryptionManager(IKeyAccessor storageEncryptionManager) {
            this.storageEncryptionManager$value = storageEncryptionManager;
            this.storageEncryptionManager$set = true;
            return this;
        }

        public SettablePlatformComponentsBuilder devicePopManager(IDevicePopManager devicePopManager) {
            this.devicePopManager$value = devicePopManager;
            this.devicePopManager$set = true;
            return this;
        }

        public SettablePlatformComponentsBuilder authorizationStrategyFactory(IAuthorizationStrategyFactory authorizationStrategyFactory) {
            this.authorizationStrategyFactory$value = authorizationStrategyFactory;
            this.authorizationStrategyFactory$set = true;
            return this;
        }

        public SettablePlatformComponents build() {
            IKeyAccessor storageEncryptionManager$value = this.storageEncryptionManager$value;
            if (!this.storageEncryptionManager$set) {
                storageEncryptionManager$value = SettablePlatformComponents.$default$storageEncryptionManager();
            }
            IDevicePopManager devicePopManager$value = this.devicePopManager$value;
            if (!this.devicePopManager$set) {
                devicePopManager$value = SettablePlatformComponents.$default$devicePopManager();
            }
            IAuthorizationStrategyFactory authorizationStrategyFactory$value = this.authorizationStrategyFactory$value;
            if (!this.authorizationStrategyFactory$set) {
                authorizationStrategyFactory$value = SettablePlatformComponents.$default$authorizationStrategyFactory();
            }
            return new SettablePlatformComponents(storageEncryptionManager$value, devicePopManager$value, authorizationStrategyFactory$value);
        }

        public String toString() {
            return "SettablePlatformComponents.SettablePlatformComponentsBuilder(storageEncryptionManager$value=" + this.storageEncryptionManager$value + ", devicePopManager$value=" + this.devicePopManager$value + ", authorizationStrategyFactory$value=" + this.authorizationStrategyFactory$value + ")";
        }
    }
}

