/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.identity.common.java.authorities.ActiveDirectoryFederationServicesAuthority;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.java.authorities.UnknownAuthority;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import java.lang.reflect.Type;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class AuthorityDeserializer
implements JsonDeserializer<Authority> {
    private static final String TAG = AuthorityDeserializer.class.getSimpleName();

    public Authority deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String methodName = ":deserialize";
        JsonObject authorityObject = json.getAsJsonObject();
        JsonElement type = authorityObject.get("type");
        if (type != null) {
            switch (type.getAsString()) {
                case "AAD": {
                    Logger.verbose(TAG + ":deserialize", "Type: AAD");
                    AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)context.deserialize((JsonElement)authorityObject, AzureActiveDirectoryAuthority.class);
                    if (aadAuthority != null) {
                        try {
                            CommonURIBuilder uri = new CommonURIBuilder(aadAuthority.getAuthorityUri());
                            String cloudUrl = uri.getScheme() + "://" + uri.getHost();
                            List pathSegments = uri.getPathSegments();
                            if (pathSegments.size() > 0) {
                                aadAuthority.mAudience = AzureActiveDirectoryAudience.getAzureActiveDirectoryAudience(cloudUrl, (String)pathSegments.get(pathSegments.size() - 1));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Logger.error(TAG + ":deserialize", e.getMessage(), e);
                        }
                    }
                    return aadAuthority;
                }
                case "B2C": {
                    Logger.verbose(TAG + ":deserialize", "Type: B2C");
                    return (Authority)context.deserialize((JsonElement)authorityObject, AzureActiveDirectoryB2CAuthority.class);
                }
                case "ADFS": {
                    Logger.verbose(TAG + ":deserialize", "Type: ADFS");
                    return (Authority)context.deserialize((JsonElement)authorityObject, ActiveDirectoryFederationServicesAuthority.class);
                }
            }
            Logger.verbose(TAG + ":deserialize", "Type: Unknown");
            return (Authority)context.deserialize((JsonElement)authorityObject, UnknownAuthority.class);
        }
        return null;
    }
}

