/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authorities.AllAccounts;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import lombok.NonNull;

public class AzureActiveDirectoryAuthority
extends Authority {
    private static final transient String TAG = AzureActiveDirectoryAuthority.class.getSimpleName();
    @SerializedName(value="audience")
    public AzureActiveDirectoryAudience mAudience;
    @SerializedName(value="flight_parameters")
    public Map<String, String> mFlightParameters;
    public boolean mMultipleCloudsSupported = false;
    private AzureActiveDirectoryCloud mAzureActiveDirectoryCloud;

    private AzureActiveDirectoryCloud getAzureActiveDirectoryCloud() {
        String methodName = ":getAzureActiveDirectoryCloud";
        AzureActiveDirectoryCloud cloud = null;
        try {
            cloud = AzureActiveDirectory.getAzureActiveDirectoryCloud(new URL(this.mAudience.getCloudUrl()));
            this.mKnownToMicrosoft = true;
        }
        catch (MalformedURLException e) {
            Logger.errorPII(TAG + ":getAzureActiveDirectoryCloud", "AAD cloud URL was malformed.", e);
            cloud = null;
            this.mKnownToMicrosoft = false;
        }
        return cloud;
    }

    public AzureActiveDirectoryAuthority(AzureActiveDirectoryAudience signInAudience) {
        this.mAudience = signInAudience;
        this.mAuthorityTypeString = "AAD";
        this.mAzureActiveDirectoryCloud = this.getAzureActiveDirectoryCloud();
    }

    public AzureActiveDirectoryAuthority() {
        this.mAudience = new AllAccounts();
        this.mAuthorityTypeString = "AAD";
        this.mMultipleCloudsSupported = false;
        this.mAzureActiveDirectoryCloud = this.getAzureActiveDirectoryCloud();
    }

    public AzureActiveDirectoryCloud getCloud() {
        return this.mAzureActiveDirectoryCloud;
    }

    public Map<String, String> getFlightParameters() {
        return this.mFlightParameters;
    }

    public void setMultipleCloudsSupported(boolean supported) {
        this.mMultipleCloudsSupported = supported;
    }

    public boolean getMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    @Override
    public URI getAuthorityUri() {
        try {
            this.getAzureActiveDirectoryCloud();
            CommonURIBuilder issuer = this.mAzureActiveDirectoryCloud == null ? new CommonURIBuilder(this.mAudience.getCloudUrl()) : new CommonURIBuilder("https://" + this.mAzureActiveDirectoryCloud.getPreferredNetworkHostName());
            if (!StringUtil.isNullOrEmpty(this.mAudience.getTenantId())) {
                ArrayList<String> pathSegments = new ArrayList<String>(issuer.getPathSegments());
                pathSegments.add(this.mAudience.getTenantId());
                issuer.setPathSegments(pathSegments);
            }
            return issuer.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Authority URI is invalid.", e);
        }
    }

    protected MicrosoftStsOAuth2Configuration createOAuth2Configuration() {
        String methodName = ":createOAuth2Configuration";
        Logger.verbose(TAG + ":createOAuth2Configuration", "Creating OAuth2Configuration");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setAuthorityUrl(this.getAuthorityURL());
        if (this.mSlice != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting slice parameters...");
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            slice.setSlice(this.mSlice.getSlice());
            slice.setDataCenter(this.mSlice.getDataCenter());
            config.setSlice(slice);
        }
        if (this.mFlightParameters != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting flight parameters...");
            for (Map.Entry<String, String> entry : this.mFlightParameters.entrySet()) {
                config.getFlightParameters().put(entry.getKey(), entry.getValue());
            }
        }
        config.setMultipleCloudsSupported(this.mMultipleCloudsSupported);
        return config;
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy(@NonNull OAuth2StrategyParameters parameters) throws ClientException {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        MicrosoftStsOAuth2Configuration config = this.createOAuth2Configuration();
        return new MicrosoftStsOAuth2Strategy(config, parameters);
    }

    public AzureActiveDirectoryAudience getAudience() {
        return this.mAudience;
    }

    public synchronized boolean isSameCloudAsAuthority(@NonNull AzureActiveDirectoryAuthority authorityToCheck) throws IOException, URISyntaxException {
        if (authorityToCheck == null) {
            throw new NullPointerException("authorityToCheck is marked non-null but is null");
        }
        if (!AzureActiveDirectory.isInitialized()) {
            AzureActiveDirectory.performCloudDiscovery();
        }
        return this.getAzureActiveDirectoryCloud().equals(authorityToCheck.getAzureActiveDirectoryCloud());
    }
}

