/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authscheme;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.authscheme.TokenAuthenticationScheme;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import lombok.NonNull;

public class PopAuthenticationSchemeInternal
extends TokenAuthenticationScheme
implements IPoPAuthenticationSchemeParams {
    private static final long serialVersionUID = 788393037295696358L;
    public static final String SCHEME_POP = "PoP";
    private transient IClockSkewManager mClockSkewManager;
    @SerializedName(value="http_method")
    private String mHttpMethod;
    @SerializedName(value="url")
    private URL mUrl;
    @SerializedName(value="nonce")
    private String mNonce;
    @SerializedName(value="client_claims")
    private String mClientClaims;
    private transient IDevicePopManager mPopManager;

    PopAuthenticationSchemeInternal() {
        super(SCHEME_POP);
    }

    public PopAuthenticationSchemeInternal(@NonNull IClockSkewManager clockSkewManager, @NonNull IDevicePopManager popManager, @Nullable String httpMethod, @NonNull URL url, @Nullable String nonce, @Nullable String clientClaims) {
        super(SCHEME_POP);
        if (clockSkewManager == null) {
            throw new NullPointerException("clockSkewManager is marked non-null but is null");
        }
        if (popManager == null) {
            throw new NullPointerException("popManager is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.mClockSkewManager = clockSkewManager;
        this.mPopManager = popManager;
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
        this.mClientClaims = clientClaims;
    }

    public PopAuthenticationSchemeInternal(@NonNull IDevicePopManager popManager, @Nullable String httpMethod, @NonNull URL url, @Nullable String nonce, @Nullable String clientClaims) {
        super(SCHEME_POP);
        if (popManager == null) {
            throw new NullPointerException("popManager is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.mClockSkewManager = null;
        this.mPopManager = popManager;
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
        this.mClientClaims = clientClaims;
    }

    @Override
    public String getAccessTokenForScheme(@NonNull String accessToken) throws ClientException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (null == this.mClockSkewManager) {
            throw new RuntimeException("IClockSkewManager not initialized.");
        }
        long ONE_SECOND_MILLIS = 1000L;
        long timestampMillis = this.mClockSkewManager.getAdjustedReferenceTime().getTime();
        return this.mPopManager.mintSignedAccessToken(this.getHttpMethod(), timestampMillis / 1000L, this.getUrl(), accessToken, this.getNonce(), this.getClientClaims());
    }

    public void setClockSkewManager(@NonNull IClockSkewManager clockSkewManager) {
        if (clockSkewManager == null) {
            throw new NullPointerException("clockSkewManager is marked non-null but is null");
        }
        this.mClockSkewManager = clockSkewManager;
    }

    @Override
    @Nullable
    public String getHttpMethod() {
        return this.mHttpMethod;
    }

    @Override
    public URL getUrl() {
        return this.mUrl;
    }

    @Override
    public String getClientClaims() {
        return this.mClientClaims;
    }

    @Override
    @Nullable
    public String getNonce() {
        return this.mNonce;
    }

    protected PopAuthenticationSchemeInternal(PopAuthenticationSchemeInternalBuilder<?, ?> b) {
        super((TokenAuthenticationScheme.TokenAuthenticationSchemeBuilder<?, ?>)b);
        this.mClockSkewManager = ((PopAuthenticationSchemeInternalBuilder)b).clockSkewManager;
        this.mHttpMethod = ((PopAuthenticationSchemeInternalBuilder)b).httpMethod;
        this.mUrl = ((PopAuthenticationSchemeInternalBuilder)b).url;
        this.mNonce = ((PopAuthenticationSchemeInternalBuilder)b).nonce;
        this.mClientClaims = ((PopAuthenticationSchemeInternalBuilder)b).clientClaims;
        this.mPopManager = ((PopAuthenticationSchemeInternalBuilder)b).popManager;
    }

    public static PopAuthenticationSchemeInternalBuilder<?, ?> builder() {
        return new PopAuthenticationSchemeInternalBuilderImpl();
    }

    public PopAuthenticationSchemeInternalBuilder<?, ?> toBuilder() {
        return new PopAuthenticationSchemeInternalBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopAuthenticationSchemeInternal)) {
            return false;
        }
        PopAuthenticationSchemeInternal other = (PopAuthenticationSchemeInternal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mHttpMethod = this.getHttpMethod();
        String other$mHttpMethod = other.getHttpMethod();
        if (this$mHttpMethod == null ? other$mHttpMethod != null : !this$mHttpMethod.equals(other$mHttpMethod)) {
            return false;
        }
        URL this$mUrl = this.getUrl();
        URL other$mUrl = other.getUrl();
        if (this$mUrl == null ? other$mUrl != null : !((Object)this$mUrl).equals(other$mUrl)) {
            return false;
        }
        String this$mNonce = this.getNonce();
        String other$mNonce = other.getNonce();
        if (this$mNonce == null ? other$mNonce != null : !this$mNonce.equals(other$mNonce)) {
            return false;
        }
        String this$mClientClaims = this.getClientClaims();
        String other$mClientClaims = other.getClientClaims();
        return !(this$mClientClaims == null ? other$mClientClaims != null : !this$mClientClaims.equals(other$mClientClaims));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PopAuthenticationSchemeInternal;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mHttpMethod = this.getHttpMethod();
        result = result * 59 + ($mHttpMethod == null ? 43 : $mHttpMethod.hashCode());
        URL $mUrl = this.getUrl();
        result = result * 59 + ($mUrl == null ? 43 : ((Object)$mUrl).hashCode());
        String $mNonce = this.getNonce();
        result = result * 59 + ($mNonce == null ? 43 : $mNonce.hashCode());
        String $mClientClaims = this.getClientClaims();
        result = result * 59 + ($mClientClaims == null ? 43 : $mClientClaims.hashCode());
        return result;
    }

    private static final class PopAuthenticationSchemeInternalBuilderImpl
    extends PopAuthenticationSchemeInternalBuilder<PopAuthenticationSchemeInternal, PopAuthenticationSchemeInternalBuilderImpl> {
        private PopAuthenticationSchemeInternalBuilderImpl() {
        }

        @Override
        protected PopAuthenticationSchemeInternalBuilderImpl self() {
            return this;
        }

        @Override
        public PopAuthenticationSchemeInternal build() {
            return new PopAuthenticationSchemeInternal(this);
        }
    }

    public static abstract class PopAuthenticationSchemeInternalBuilder<C extends PopAuthenticationSchemeInternal, B extends PopAuthenticationSchemeInternalBuilder<C, B>>
    extends TokenAuthenticationScheme.TokenAuthenticationSchemeBuilder<C, B> {
        private IClockSkewManager clockSkewManager;
        private String httpMethod;
        private URL url;
        private String nonce;
        private String clientClaims;
        private IDevicePopManager popManager;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PopAuthenticationSchemeInternalBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(PopAuthenticationSchemeInternal instance, PopAuthenticationSchemeInternalBuilder<?, ?> b) {
            b.clockSkewManager(instance.mClockSkewManager);
            b.httpMethod(instance.mHttpMethod);
            b.url(instance.mUrl);
            b.nonce(instance.mNonce);
            b.clientClaims(instance.mClientClaims);
            b.popManager(instance.mPopManager);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B clockSkewManager(IClockSkewManager clockSkewManager) {
            this.clockSkewManager = clockSkewManager;
            return (B)this.self();
        }

        public B httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return (B)this.self();
        }

        public B url(URL url) {
            this.url = url;
            return (B)this.self();
        }

        public B nonce(String nonce) {
            this.nonce = nonce;
            return (B)this.self();
        }

        public B clientClaims(String clientClaims) {
            this.clientClaims = clientClaims;
            return (B)this.self();
        }

        public B popManager(IDevicePopManager popManager) {
            this.popManager = popManager;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PopAuthenticationSchemeInternal.PopAuthenticationSchemeInternalBuilder(super=" + super.toString() + ", clockSkewManager=" + this.clockSkewManager + ", httpMethod=" + this.httpMethod + ", url=" + this.url + ", nonce=" + this.nonce + ", clientClaims=" + this.clientClaims + ", popManager=" + this.popManager + ")";
        }
    }

    public static final class SerializedNames {
        public static final String HTTP_METHOD = "http_method";
        public static final String URL = "url";
        public static final String NONCE = "nonce";
        public static final String CLIENT_CLAIMS = "client_claims";
    }
}

