/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.CacheRecord;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.IAccountCredentialCache;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.java.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.CacheEndEvent;
import com.microsoft.identity.common.java.telemetry.events.CacheStartEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class MsalOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends OAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse>
implements IShareSingleSignOnState<GenericAccount, GenericRefreshToken> {
    private static final String TAG = MsalOAuth2TokenCache.class.getSimpleName();
    private static final Object sCacheLock = new Object();
    private IAccountCredentialCache mAccountCredentialCache;
    private final IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> mAccountCredentialAdapter;

    public MsalOAuth2TokenCache(IPlatformComponents commonComponents, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> accountCredentialAdapter) {
        super(commonComponents);
        Logger.verbose(TAG, "Init: " + TAG);
        this.mAccountCredentialCache = accountCredentialCache;
        this.mAccountCredentialAdapter = accountCredentialAdapter;
    }

    public static MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> create(@NonNull IPlatformComponents components) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        String methodName = ":create";
        Logger.verbose(TAG + ":create", "Creating MsalOAuth2TokenCache");
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        INameValueStorage<String> sharedPreferencesFileManager = components.getEncryptedNameValueStore("com.microsoft.identity.client.account_credential_cache", components.getStorageEncryptionManager(), String.class);
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache(cacheKeyValueDelegate, sharedPreferencesFileManager);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return new MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(components, accountCredentialCache, accountCredentialAdapter);
    }

    void validateNonNull(@Nullable Object object, @NonNull String type) throws ClientException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String message = type + " passed in is Null";
        if (object == null) {
            Logger.warn(TAG, message);
            throw new ClientException(message);
        }
    }

    @Override
    @Deprecated
    ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord) throws ClientException {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        String methodName = ":save (3 arg)";
        boolean isAccountValid = this.isAccountSchemaCompliant(accountRecord);
        boolean isIdTokenValid = this.isIdTokenSchemaCompliant(idTokenRecord);
        boolean isAccessTokenValid = this.isAccessTokenSchemaCompliant(accessTokenRecord);
        if (!isAccountValid) {
            throw new ClientException("Account is missing schema-required fields.");
        }
        if (!isIdTokenValid) {
            throw new ClientException("Credential is missing schema-required fields.", "[(ID)]");
        }
        if (!isAccessTokenValid) {
            throw new ClientException("Credential is missing schema-required fields.", "[(AT)]");
        }
        Logger.verbose(TAG + ":save (3 arg)", "Accounts/Credentials are valid.... proceeding");
        this.saveAccounts(accountRecord);
        this.saveCredentialsInternal(idTokenRecord, accessTokenRecord);
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        result.account(accountRecord);
        result.accessToken(accessTokenRecord);
        if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenRecord.getCredentialType())) {
            result.v1IdToken(idTokenRecord);
        } else {
            result.idToken(idTokenRecord);
        }
        return result.build();
    }

    ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable RefreshTokenRecord refreshTokenRecord) throws ClientException {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        String methodName = ":save (4 arg)";
        if (!this.isAccountSchemaCompliant(accountRecord)) {
            throw new ClientException("Account is missing schema-required fields.");
        }
        if (!this.isIdTokenSchemaCompliant(idTokenRecord)) {
            throw new ClientException("Credential is missing schema-required fields.", "[(ID)]");
        }
        if (!this.isAccessTokenSchemaCompliant(accessTokenRecord)) {
            throw new ClientException("Credential is missing schema-required fields.", "[(AT)]");
        }
        if (refreshTokenRecord != null && !this.isRefreshTokenSchemaCompliant(refreshTokenRecord)) {
            throw new ClientException("Credential is missing schema-required fields.", "[(RT)]");
        }
        Logger.verbose(TAG + ":save (4 arg)", "Accounts/Credentials are valid.... proceeding");
        this.saveAccounts(accountRecord);
        this.saveCredentialsInternal(idTokenRecord, accessTokenRecord, refreshTokenRecord);
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        result.account(accountRecord);
        result.accessToken(accessTokenRecord);
        result.refreshToken(refreshTokenRecord);
        if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenRecord.getCredentialType())) {
            result.v1IdToken(idTokenRecord);
        } else {
            result.idToken(idTokenRecord);
        }
        return result.build();
    }

    @Override
    @NonNull
    List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord) throws ClientException {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        if (accessTokenRecord == null) {
            throw new NullPointerException("accessTokenRecord is marked non-null but is null");
        }
        return this.mergeCacheRecordWithOtherTenantCacheRecords(this.save(accountRecord, idTokenRecord, accessTokenRecord));
    }

    @NonNull
    private List<ICacheRecord> mergeCacheRecordWithOtherTenantCacheRecords(@NonNull ICacheRecord savedCacheRecord) {
        if (savedCacheRecord == null) {
            throw new NullPointerException("savedCacheRecord is marked non-null but is null");
        }
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        result.add(savedCacheRecord);
        ArrayList<AccountRecord> accountsInOtherTenants = new ArrayList<AccountRecord>(this.getAllTenantAccountsForAccountByClientId(savedCacheRecord.getRefreshToken().getClientId(), savedCacheRecord.getAccount()));
        if (!accountsInOtherTenants.isEmpty()) {
            accountsInOtherTenants.remove(0);
            for (AccountRecord acct : accountsInOtherTenants) {
                result.add(this.getSparseCacheRecordForAccount(savedCacheRecord.getRefreshToken().getClientId(), acct));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        AccountRecord accountToSave = this.mAccountCredentialAdapter.createAccount(oAuth2Strategy, request, response);
        AccessTokenRecord accessTokenToSave = this.mAccountCredentialAdapter.createAccessToken(oAuth2Strategy, request, response);
        RefreshTokenRecord refreshTokenToSave = this.mAccountCredentialAdapter.createRefreshToken(oAuth2Strategy, request, response);
        IdTokenRecord idTokenToSave = this.mAccountCredentialAdapter.createIdToken(oAuth2Strategy, request, response);
        this.validateCacheArtifacts(accountToSave, accessTokenToSave, refreshTokenToSave, idTokenToSave);
        this.saveAccounts(accountToSave);
        Object object = sCacheLock;
        synchronized (object) {
            this.saveCredentialsInternal(accessTokenToSave, refreshTokenToSave, idTokenToSave);
            this.removeAllRefreshTokensExcept(accountToSave, refreshTokenToSave);
        }
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        result.account(accountToSave);
        result.accessToken(accessTokenToSave);
        result.refreshToken(refreshTokenToSave);
        this.setToCacheRecord(result, idTokenToSave);
        return result.build();
    }

    private void removeAllRefreshTokensExcept(@NonNull AccountRecord accountRecord, @NonNull RefreshTokenRecord deletionExemptRefreshToken) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (deletionExemptRefreshToken == null) {
            throw new NullPointerException("deletionExemptRefreshToken is marked non-null but is null");
        }
        String methodName = ":removeAllRefreshTokensExcept";
        boolean isFamilyRefreshToken = !StringUtil.isNullOrEmpty(deletionExemptRefreshToken.getFamilyId());
        Logger.info(TAG + ":removeAllRefreshTokensExcept", "isFamilyRefreshToken? [" + isFamilyRefreshToken + "]");
        boolean isMultiResourceCapable = "MSSTS".equals(accountRecord.getAuthorityType());
        Logger.info(TAG + ":removeAllRefreshTokensExcept", "isMultiResourceCapable? [" + isMultiResourceCapable + "]");
        if (isFamilyRefreshToken || isMultiResourceCapable) {
            String environment = accountRecord.getEnvironment();
            String clientId = deletionExemptRefreshToken.getClientId();
            int refreshTokensRemoved = this.removeCredentialsOfTypeForAccountExcept(environment, isFamilyRefreshToken ? null : clientId, CredentialType.RefreshToken, accountRecord, true, deletionExemptRefreshToken);
            Logger.info(TAG + ":removeAllRefreshTokensExcept", "Refresh tokens removed: [" + refreshTokensRemoved + "]");
            if (refreshTokensRemoved > 1) {
                Logger.warn(TAG + ":removeAllRefreshTokensExcept", "Multiple refresh tokens found for Account.");
            }
        }
    }

    private int removeCredentialsOfTypeForAccountExcept(@NonNull String environment, @Nullable String clientId, @NonNull CredentialType credentialType, @NonNull AccountRecord targetAccount, boolean realmAgnostic, @NonNull Credential deletionExemptRecord) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (credentialType == null) {
            throw new NullPointerException("credentialType is marked non-null but is null");
        }
        if (targetAccount == null) {
            throw new NullPointerException("targetAccount is marked non-null but is null");
        }
        if (deletionExemptRecord == null) {
            throw new NullPointerException("deletionExemptRecord is marked non-null but is null");
        }
        int credentialsRemoved = 0;
        List<Credential> credentialsToRemove = this.mAccountCredentialCache.getCredentialsFilteredBy(targetAccount.getHomeAccountId(), environment, credentialType, clientId, realmAgnostic ? null : targetAccount.getRealm(), null, null);
        for (Credential credentialToRemove : credentialsToRemove) {
            if (deletionExemptRecord.equals(credentialToRemove) || !this.mAccountCredentialCache.removeCredential(credentialToRemove)) continue;
            ++credentialsRemoved;
        }
        return credentialsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        MsalOAuth2TokenCache msalOAuth2TokenCache = this;
        synchronized (msalOAuth2TokenCache) {
            return this.mergeCacheRecordWithOtherTenantCacheRecords(this.save(oAuth2Strategy, request, response));
        }
    }

    ICacheRecord getSparseCacheRecordForAccount(@NonNull String clientId, @NonNull AccountRecord acct) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (acct == null) {
            throw new NullPointerException("acct is marked non-null but is null");
        }
        String methodName = ":getSparseCacheRecordForAccount";
        List<IdTokenRecord> acctIdTokens = this.getIdTokensForAccountRecord(clientId, acct);
        if (acctIdTokens.size() > CredentialType.ID_TOKEN_TYPES.size()) {
            Logger.warn(TAG + ":getSparseCacheRecordForAccount", "Found more IdTokens than expected.\nFound: [" + acctIdTokens.size() + "]");
        }
        CacheRecord.CacheRecordBuilder associatedRecord = CacheRecord.builder();
        associatedRecord.account(acct);
        for (IdTokenRecord idTokenRecord : acctIdTokens) {
            this.setToCacheRecord(associatedRecord, idTokenRecord);
        }
        return associatedRecord.build();
    }

    void removeRefreshTokenIfNeeded(@NonNull AccountRecord accountRecord, @NonNull RefreshTokenRecord refreshTokenRecord) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        if (refreshTokenRecord == null) {
            throw new NullPointerException("refreshTokenRecord is marked non-null but is null");
        }
        String methodName = ":removeRefreshTokenIfNeeded";
        boolean isFamilyRefreshToken = !StringUtil.isNullOrEmpty(refreshTokenRecord.getFamilyId());
        Logger.info(TAG + ":removeRefreshTokenIfNeeded", "isFamilyRefreshToken? [" + isFamilyRefreshToken + "]");
        boolean isMultiResourceCapable = "MSSTS".equals(accountRecord.getAuthorityType());
        Logger.info(TAG + ":removeRefreshTokenIfNeeded", "isMultiResourceCapable? [" + isMultiResourceCapable + "]");
        if (isFamilyRefreshToken || isMultiResourceCapable) {
            String environment = accountRecord.getEnvironment();
            String clientId = refreshTokenRecord.getClientId();
            int refreshTokensRemoved = this.removeRefreshTokensForAccount(accountRecord, isFamilyRefreshToken, environment, clientId);
            Logger.info(TAG + ":removeRefreshTokenIfNeeded", "Refresh tokens removed: [" + refreshTokensRemoved + "]");
            if (refreshTokensRemoved > 1) {
                Logger.warn(TAG + ":removeRefreshTokenIfNeeded", "Multiple refresh tokens found for Account.");
            }
        }
    }

    private int removeRefreshTokensForAccount(@NonNull AccountRecord accountToSave, boolean isFamilyRefreshToken, @NonNull String environment, @Nullable String clientId) {
        if (accountToSave == null) {
            throw new NullPointerException("accountToSave is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return this.removeCredentialsOfTypeForAccount(environment, isFamilyRefreshToken ? null : clientId, CredentialType.RefreshToken, accountToSave, true);
    }

    @Override
    public ICacheRecord save(@NonNull AccountRecord accountToSave, @NonNull IdTokenRecord idTokenToSave) {
        if (accountToSave == null) {
            throw new NullPointerException("accountToSave is marked non-null but is null");
        }
        if (idTokenToSave == null) {
            throw new NullPointerException("idTokenToSave is marked non-null but is null");
        }
        String methodName = ":save";
        Logger.verbose(TAG + ":save", "Importing AccountRecord, IdTokenRecord (direct)");
        boolean isAccountCompliant = this.isAccountSchemaCompliant(accountToSave);
        boolean isIdTokenCompliant = this.isIdTokenSchemaCompliant(idTokenToSave);
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        if (!isAccountCompliant || !isIdTokenCompliant) {
            String nonCompliantCredentials = "[";
            if (!isAccountCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(Account)";
            }
            if (!isIdTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(ID)";
            }
            nonCompliantCredentials = nonCompliantCredentials + "]";
            Logger.warn(TAG + ":save", "Skipping persistence of non-compliant credentials: " + nonCompliantCredentials);
        } else {
            this.saveAccounts(accountToSave);
            this.saveCredentialsInternal(idTokenToSave);
            result.account(accountToSave);
            if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenToSave.getCredentialType())) {
                result.v1IdToken(idTokenToSave);
            } else {
                result.idToken(idTokenToSave);
            }
        }
        return result.build();
    }

    @Override
    public ICacheRecord load(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        RefreshTokenRecord fallbackFrt;
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        Telemetry.emit(new CacheStartEvent());
        boolean isMultiResourceCapable = "MSSTS".equals(account.getAuthorityType());
        List<Credential> allCredentials = this.mAccountCredentialCache.getCredentials();
        List<Credential> accessTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), this.getAccessTokenCredentialTypeForAuthenticationScheme(authScheme), clientId, account.getRealm(), target, authScheme.getName(), allCredentials);
        List<Credential> refreshTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.RefreshToken, clientId, isMultiResourceCapable ? null : account.getRealm(), isMultiResourceCapable ? null : target, null, allCredentials);
        if (refreshTokens.isEmpty() && null != (fallbackFrt = this.getFamilyRefreshTokenForAccount(account))) {
            refreshTokens = new ArrayList<Credential>();
            refreshTokens.add(fallbackFrt);
        }
        List<Credential> idTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.IdToken, clientId, account.getRealm(), null, null, allCredentials);
        List<Credential> v1IdTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.V1IdToken, clientId, account.getRealm(), null, null, allCredentials);
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        result.account(account);
        result.accessToken(accessTokens.isEmpty() ? null : (AccessTokenRecord)accessTokens.get(0));
        result.refreshToken(refreshTokens.isEmpty() ? null : (RefreshTokenRecord)refreshTokens.get(0));
        result.idToken(idTokens.isEmpty() ? null : (IdTokenRecord)idTokens.get(0));
        result.v1IdToken(v1IdTokens.isEmpty() ? null : (IdTokenRecord)v1IdTokens.get(0));
        Telemetry.emit(new CacheEndEvent().putCacheRecordStatus(result.build()));
        return result.build();
    }

    @Nullable
    private RefreshTokenRecord getFamilyRefreshTokenForAccount(@NonNull AccountRecord account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        String methodName = ":getFamilyRefreshTokensForAccount";
        RefreshTokenRecord result = null;
        List<Credential> fallbackRts = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.RefreshToken, null, null, null, null);
        if (!fallbackRts.isEmpty()) {
            Logger.verbose(TAG + ":getFamilyRefreshTokensForAccount", "Inspecting fallback RTs for a FoCI match.");
            for (Credential rt : fallbackRts) {
                RefreshTokenRecord refreshTokenRecord;
                boolean isFamilyRefreshToken;
                if (!(rt instanceof RefreshTokenRecord) || !(isFamilyRefreshToken = !StringUtil.isNullOrEmpty((refreshTokenRecord = (RefreshTokenRecord)rt).getFamilyId()))) continue;
                Logger.verbose(TAG + ":getFamilyRefreshTokensForAccount", "Fallback RT found.");
                result = refreshTokenRecord;
                break;
            }
        }
        return result;
    }

    @Nullable
    public RefreshTokenRecord getFamilyRefreshTokenForHomeAccountId(@NonNull String homeAccountId) {
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        for (AccountRecord accountRecord : this.mAccountCredentialCache.getAccounts()) {
            if (!accountRecord.getHomeAccountId().equals(homeAccountId)) continue;
            return this.getFamilyRefreshTokenForAccount(accountRecord);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> loadWithAggregatedAccountData(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @NonNull AbstractAuthenticationScheme authScheme) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        MsalOAuth2TokenCache msalOAuth2TokenCache = this;
        synchronized (msalOAuth2TokenCache) {
            ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
            ICacheRecord primaryCacheRecord = this.load(clientId, target, account, authScheme);
            result.add(primaryCacheRecord);
            List<ICacheRecord> corollaryCacheRecords = this.getAccountsWithAggregatedAccountData(account.getEnvironment(), clientId, account.getHomeAccountId());
            for (ICacheRecord cacheRecord : corollaryCacheRecords) {
                if (account.equals(cacheRecord.getAccount())) continue;
                result.add(cacheRecord);
            }
            return result;
        }
    }

    @Override
    public List<IdTokenRecord> getIdTokensForAccountRecord(@Nullable String clientId, @NonNull AccountRecord accountRecord) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        ArrayList<IdTokenRecord> result = new ArrayList<IdTokenRecord>();
        List<Credential> allCredentials = this.mAccountCredentialCache.getCredentials();
        List<Credential> idTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(accountRecord.getHomeAccountId(), accountRecord.getEnvironment(), CredentialType.IdToken, clientId, accountRecord.getRealm(), null, null, allCredentials);
        idTokens.addAll(this.mAccountCredentialCache.getCredentialsFilteredBy(accountRecord.getHomeAccountId(), accountRecord.getEnvironment(), CredentialType.V1IdToken, clientId, accountRecord.getRealm(), null, null, allCredentials));
        for (Credential credential : idTokens) {
            if (!(credential instanceof IdTokenRecord)) continue;
            result.add((IdTokenRecord)credential);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean removeCredential(Credential credential) {
        String methodName = ":removeCredential";
        Logger.info(TAG + ":removeCredential", "Removing credential...");
        Logger.verbosePII(TAG + ":removeCredential", "ClientId: [" + credential.getClientId() + "]\nCredentialType: [" + credential.getCredentialType() + "]\nCachedAt: [" + credential.getCachedAt() + "]\nEnvironment: [" + credential.getEnvironment() + "]\nHomeAccountId: [" + credential.getHomeAccountId() + "]\nIsExpired?: [" + credential.isExpired() + "]");
        return this.mAccountCredentialCache.removeCredential(credential);
    }

    @Override
    @Nullable
    public AccountRecord getAccount(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId, @Nullable String realm) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        String methodName = ":getAccount";
        Logger.verbosePII(TAG + ":getAccount", "Environment: [" + environment + "]\nClientId: [" + clientId + "]\nHomeAccountId: [" + homeAccountId + "]\nRealm: [" + realm + "]");
        List<AccountRecord> allAccounts = this.getAccounts(environment, clientId);
        Logger.info(TAG + ":getAccount", "Found " + allAccounts.size() + " accounts");
        for (AccountRecord account : allAccounts) {
            if (!homeAccountId.equals(account.getHomeAccountId()) || null != realm && !realm.equals(account.getRealm())) continue;
            return account;
        }
        Logger.warn(TAG + ":getAccount", "No matching account found.");
        return null;
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        AccountRecord anyMatchingAccount = this.getAccount(environment, clientId, homeAccountId, null);
        if (null != anyMatchingAccount) {
            List<AccountRecord> corollaryAccounts = this.getAllTenantAccountsForAccountByClientId(clientId, anyMatchingAccount);
            for (AccountRecord accountRecord : corollaryAccounts) {
                result.add(this.getSparseCacheRecordForAccount(clientId, accountRecord));
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @Nullable
    public AccountRecord getAccountByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (localAccountId == null) {
            throw new NullPointerException("localAccountId is marked non-null but is null");
        }
        String methodName = ":getAccountByLocalAccountId";
        List<AccountRecord> accounts = this.getAccounts(environment, clientId);
        Logger.verbosePII(TAG + ":getAccountByLocalAccountId", "LocalAccountId: [" + localAccountId + "]");
        for (AccountRecord account : accounts) {
            if (!localAccountId.equals(account.getLocalAccountId())) continue;
            return account;
        }
        return null;
    }

    public List<AccountRecord> getAccountsByUsername(@Nullable String environment, @NonNull String clientId, @NonNull String username) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        String methodName = ":getAccountsByUsername";
        ArrayList<AccountRecord> result = new ArrayList<AccountRecord>();
        List<AccountRecord> accounts = this.getAccounts(environment, clientId);
        for (AccountRecord account : accounts) {
            if (!StringUtil.equalsIgnoreCase(account.getUsername(), username)) continue;
            result.add(account);
        }
        Logger.verbose(TAG + ":getAccountsByUsername", "Found " + accounts.size() + " accounts matching username.");
        return result;
    }

    @Override
    @Nullable
    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (localAccountId == null) {
            throw new NullPointerException("localAccountId is marked non-null but is null");
        }
        CacheRecord.CacheRecordBuilder result = null;
        AccountRecord acct = this.getAccountByLocalAccountId(environment, clientId, localAccountId);
        if (null != acct) {
            List<IdTokenRecord> acctIdTokens = this.getIdTokensForAccountRecord(clientId, acct);
            result = CacheRecord.builder();
            result.account(acct);
            for (IdTokenRecord idTokenRecord : acctIdTokens) {
                this.setToCacheRecord(result, idTokenRecord);
            }
            return result.build();
        }
        return null;
    }

    private void setToCacheRecord(@NonNull CacheRecord.CacheRecordBuilder target, @NonNull IdTokenRecord idTokenRecord) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (idTokenRecord == null) {
            throw new NullPointerException("idTokenRecord is marked non-null but is null");
        }
        String methodName = ":setToCacheRecord";
        CredentialType type = CredentialType.fromString(idTokenRecord.getCredentialType());
        if (null != type) {
            if (CredentialType.V1IdToken == type) {
                target.v1IdToken(idTokenRecord);
            } else if (CredentialType.IdToken == type) {
                target.idToken(idTokenRecord);
            } else {
                Logger.warn(TAG + ":setToCacheRecord", "Unrecognized IdToken type: " + idTokenRecord.getCredentialType());
            }
        }
    }

    @Override
    public List<AccountRecord> getAccounts(@Nullable String environment, @NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        String methodName = ":getAccounts";
        Logger.verbosePII(TAG + ":getAccounts", "Environment: [" + environment + "]\nClientId: [" + clientId + "]");
        ArrayList<AccountRecord> accountsForThisApp = new ArrayList<AccountRecord>();
        List<AccountRecord> accountsForEnvironment = this.mAccountCredentialCache.getAccountsFilteredBy(null, environment, null);
        Logger.verbose(TAG + ":getAccounts", "Found " + accountsForEnvironment.size() + " accounts for this environment");
        HashSet<CredentialType> credentialTypes = new HashSet<CredentialType>(Arrays.asList(CredentialType.IdToken, CredentialType.V1IdToken, CredentialType.RefreshToken));
        List<Credential> appCredentials = this.mAccountCredentialCache.getCredentialsFilteredBy(null, environment, credentialTypes, clientId, null, null, null, null);
        for (AccountRecord account : accountsForEnvironment) {
            if (!this.accountHasCredential(account, appCredentials)) continue;
            accountsForThisApp.add(account);
        }
        Logger.verbose(TAG + ":getAccounts", "Found " + accountsForThisApp.size() + " accounts for this clientId");
        return Collections.unmodifiableList(accountsForThisApp);
    }

    @Override
    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(@NonNull String clientId, @NonNull AccountRecord accountRecord) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        ArrayList<AccountRecord> allTenantAccounts = new ArrayList<AccountRecord>();
        allTenantAccounts.add(accountRecord);
        List<AccountRecord> allMatchingAccountsByHomeId = this.mAccountCredentialCache.getAccountsFilteredBy(accountRecord.getHomeAccountId(), accountRecord.getEnvironment(), null);
        List<AccountRecord> allAppAccounts = this.getAccounts(accountRecord.getEnvironment(), clientId);
        for (AccountRecord acct : allAppAccounts) {
            if (!allMatchingAccountsByHomeId.contains(acct) || accountRecord.equals(acct)) continue;
            allTenantAccounts.add(acct);
        }
        return Collections.unmodifiableList(allTenantAccounts);
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(@Nullable String environment, @NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        String methodName = ":getAccountsWithAggregatedAccountData";
        ArrayList<CacheRecord> result = new ArrayList<CacheRecord>();
        List<AccountRecord> allMatchingAccounts = this.getAccounts(environment, clientId);
        for (AccountRecord accountRecord : allMatchingAccounts) {
            List<IdTokenRecord> idTokensForAccount = this.getIdTokensForAccountRecord(clientId, accountRecord);
            if (idTokensForAccount == null || idTokensForAccount.size() == 0) continue;
            CacheRecord.CacheRecordBuilder cacheRecordBuilder = CacheRecord.builder();
            cacheRecordBuilder.account(accountRecord);
            for (IdTokenRecord idTokenRecord : idTokensForAccount) {
                this.setToCacheRecord(cacheRecordBuilder, idTokenRecord);
            }
            result.add(cacheRecordBuilder.build());
        }
        Logger.verbose(TAG + ":getAccountsWithAggregatedAccountData", "Found " + result.size() + " accounts with IdTokens");
        return Collections.unmodifiableList(result);
    }

    private CredentialType getAccessTokenCredentialTypeForAuthenticationScheme(@NonNull AbstractAuthenticationScheme authScheme) {
        if (authScheme == null) {
            throw new NullPointerException("authScheme is marked non-null but is null");
        }
        if ("Bearer".equalsIgnoreCase(authScheme.getName())) {
            return CredentialType.AccessToken;
        }
        return CredentialType.AccessToken_With_AuthScheme;
    }

    private boolean accountHasCredential(@NonNull AccountRecord account, @NonNull List<Credential> appCredentials) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (appCredentials == null) {
            throw new NullPointerException("appCredentials is marked non-null but is null");
        }
        String methodName = ":accountHasCredential";
        String accountHomeId = account.getHomeAccountId();
        String accountEnvironment = account.getEnvironment();
        Logger.verbosePII(TAG + ":accountHasCredential", "HomeAccountId: [" + accountHomeId + "]\nEnvironment: [" + accountEnvironment + "]");
        for (Credential credential : appCredentials) {
            if (!accountHomeId.equals(credential.getHomeAccountId()) || !accountEnvironment.equals(credential.getEnvironment())) continue;
            Logger.verbose(TAG + ":accountHasCredential", "Credentials located for account.");
            return true;
        }
        return false;
    }

    @Override
    public AccountDeletionRecord removeAccount(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm) {
        return this.removeAccount(environment, clientId, homeAccountId, realm, CredentialType.AccessToken, CredentialType.AccessToken_With_AuthScheme, CredentialType.RefreshToken, CredentialType.IdToken, CredentialType.V1IdToken);
    }

    @Override
    public AccountDeletionRecord removeAccount(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm, CredentialType ... typesToRemove) {
        AccountRecord targetAccount;
        String methodName = ":removeAccount";
        Logger.verbosePII(TAG + ":removeAccount", "Environment: [" + environment + "]\nClientId: [" + clientId + "]\nHomeAccountId: [" + homeAccountId + "]\nRealm: [" + realm + "]\nCredentialTypes to delete: [" + Arrays.toString((Object[])typesToRemove) + "]");
        if (null == clientId || null == homeAccountId || null == (targetAccount = this.getAccount(environment, clientId, homeAccountId, realm))) {
            Logger.warn(TAG + ":removeAccount", "Insufficient filtering provided for account removal - preserving Account.");
            return new AccountDeletionRecord(null);
        }
        boolean isRealmAgnostic = null == realm;
        Logger.verbose(TAG + ":removeAccount", "IsRealmAgnostic? " + isRealmAgnostic);
        if (null != typesToRemove && typesToRemove.length > 0) {
            for (CredentialType type : typesToRemove) {
                int deletedCredentialsOfTypeCount = this.removeCredentialsOfTypeForAccount(environment, clientId, type, targetAccount, isRealmAgnostic);
                Logger.info(TAG + ":removeAccount", "Removed " + deletedCredentialsOfTypeCount + " credentials of type: " + (Object)((Object)type));
            }
        } else {
            Logger.warn(TAG + ":removeAccount", "removeAccount called, but no CredentialTypes to remove specified");
        }
        ArrayList<AccountRecord> deletedAccounts = new ArrayList<AccountRecord>();
        if (isRealmAgnostic) {
            List<AccountRecord> accountsToRemove = this.mAccountCredentialCache.getAccountsFilteredBy(homeAccountId, environment, null);
            for (AccountRecord accountToRemove : accountsToRemove) {
                if (!this.mAccountCredentialCache.removeAccount(accountToRemove)) continue;
                deletedAccounts.add(accountToRemove);
            }
        } else if (this.mAccountCredentialCache.removeAccount(targetAccount)) {
            deletedAccounts.add(targetAccount);
        }
        return new AccountDeletionRecord(deletedAccounts);
    }

    @Override
    public void clearAll() {
        String methodName = ":clearAll";
        Logger.warn(TAG + ":clearAll", "Clearing cache.");
        this.mAccountCredentialCache.clearAll();
    }

    @Override
    protected Set<String> getAllClientIds() {
        String methodName = ":getAllClientIds";
        HashSet<String> result = new HashSet<String>();
        for (Credential credential : this.mAccountCredentialCache.getCredentials()) {
            result.add(credential.getClientId());
        }
        Logger.verbose(TAG + ":getAllClientIds", "Found [" + result.size() + "] clientIds/");
        return result;
    }

    @Override
    @Nullable
    public AccountRecord getAccountByHomeAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        String methodName = ":getAccountByHomeAccountId";
        List<AccountRecord> accounts = this.getAccounts(environment, clientId);
        Logger.verbosePII(TAG + ":getAccountByHomeAccountId", "homeAccountId: [" + homeAccountId + "]");
        for (AccountRecord account : accounts) {
            if (!homeAccountId.equals(account.getHomeAccountId())) continue;
            return account;
        }
        return null;
    }

    private int removeCredentialsOfTypeForAccount(@Nullable String environment, @Nullable String clientId, @NonNull CredentialType credentialType, @NonNull AccountRecord targetAccount, boolean realmAgnostic) {
        if (credentialType == null) {
            throw new NullPointerException("credentialType is marked non-null but is null");
        }
        if (targetAccount == null) {
            throw new NullPointerException("targetAccount is marked non-null but is null");
        }
        int credentialsRemoved = 0;
        List<Credential> credentialsToRemove = this.mAccountCredentialCache.getCredentialsFilteredBy(targetAccount.getHomeAccountId(), environment, credentialType, clientId, realmAgnostic ? null : targetAccount.getRealm(), null, null);
        for (Credential credentialToRemove : credentialsToRemove) {
            if (!this.mAccountCredentialCache.removeCredential(credentialToRemove)) continue;
            ++credentialsRemoved;
        }
        return credentialsRemoved;
    }

    private void saveAccounts(AccountRecord ... accounts) {
        for (AccountRecord account : accounts) {
            this.mAccountCredentialCache.saveAccount(account);
        }
    }

    void saveCredentialsInternal(Credential ... credentials) {
        for (Credential credential : credentials) {
            if (credential == null) continue;
            if (credential instanceof AccessTokenRecord) {
                this.deleteAccessTokensWithIntersectingScopes((AccessTokenRecord)credential);
            }
            this.mAccountCredentialCache.saveCredential(credential);
        }
    }

    void validateCacheArtifacts(@NonNull AccountRecord accountToSave, AccessTokenRecord accessTokenToSave, @NonNull RefreshTokenRecord refreshTokenToSave, @NonNull IdTokenRecord idTokenToSave) throws ClientException {
        if (accountToSave == null) {
            throw new NullPointerException("accountToSave is marked non-null but is null");
        }
        if (refreshTokenToSave == null) {
            throw new NullPointerException("refreshTokenToSave is marked non-null but is null");
        }
        if (idTokenToSave == null) {
            throw new NullPointerException("idTokenToSave is marked non-null but is null");
        }
        String methodName = ":validateCacheArtifacts";
        Logger.verbose(TAG + ":validateCacheArtifacts", "Validating cache artifacts...");
        boolean isAccountCompliant = this.isAccountSchemaCompliant(accountToSave);
        boolean isAccessTokenCompliant = null == accessTokenToSave || this.isAccessTokenSchemaCompliant(accessTokenToSave);
        boolean isRefreshTokenCompliant = this.isRefreshTokenSchemaCompliant(refreshTokenToSave);
        boolean isIdTokenCompliant = this.isIdTokenSchemaCompliant(idTokenToSave);
        if (!isAccountCompliant) {
            throw new ClientException("Account is missing schema-required fields.");
        }
        if (!(isAccessTokenCompliant && isRefreshTokenCompliant && isIdTokenCompliant)) {
            String nonCompliantCredentials = "[";
            if (!isAccessTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(AT)";
            }
            if (!isRefreshTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(RT)";
            }
            if (!isIdTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(ID)";
            }
            nonCompliantCredentials = nonCompliantCredentials + "]";
            throw new ClientException("Credential is missing schema-required fields.", nonCompliantCredentials);
        }
    }

    private void deleteAccessTokensWithIntersectingScopes(AccessTokenRecord referenceToken) {
        String methodName = "deleteAccessTokensWithIntersectingScopes";
        List<Credential> accessTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(referenceToken.getHomeAccountId(), referenceToken.getEnvironment(), CredentialType.fromString(referenceToken.getCredentialType()), referenceToken.getClientId(), referenceToken.getRealm(), null, referenceToken.getAccessTokenType(), referenceToken.getRequestedClaims());
        Logger.verbose(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Inspecting " + accessTokens.size() + " accessToken[s].");
        for (Credential accessToken : accessTokens) {
            if (!this.scopesIntersect(referenceToken, (AccessTokenRecord)accessToken, true)) continue;
            Logger.infoPII(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Removing credential: " + accessToken);
            this.mAccountCredentialCache.removeCredential(accessToken);
        }
    }

    private boolean scopesIntersect(AccessTokenRecord token1, AccessTokenRecord token2, boolean omitDefaultScopes) {
        String methodName = "scopesIntersect";
        Set<String> token1Scopes = this.scopesAsSet(token1);
        Set<String> token2Scopes = this.scopesAsSet(token2);
        if (omitDefaultScopes) {
            token1Scopes.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
            token2Scopes.removeAll(AuthenticationConstants.DEFAULT_SCOPES);
        }
        boolean result = false;
        for (String scope : token2Scopes) {
            if (!token1Scopes.contains(scope)) continue;
            Logger.info(TAG + ":" + "scopesIntersect", "Scopes intersect.");
            Logger.infoPII(TAG + ":" + "scopesIntersect", token1Scopes.toString() + " contains [" + scope + "]");
            result = true;
            break;
        }
        return result;
    }

    private Set<String> scopesAsSet(AccessTokenRecord token) {
        HashSet<String> scopeSet = new HashSet<String>();
        String scopeString = token.getTarget();
        if (!StringUtil.isNullOrEmpty(scopeString)) {
            String[] scopeArray = scopeString.split("\\s+");
            scopeSet.addAll(Arrays.asList(scopeArray));
        }
        return scopeSet;
    }

    private static boolean isSchemaCompliant(Class<?> clazz, String[][] params) {
        String methodName = "isSchemaCompliant";
        boolean isCompliant = true;
        for (String[] param : params) {
            isCompliant = isCompliant && !StringUtil.isNullOrEmpty(param[1]);
        }
        if (!isCompliant) {
            Logger.warn(TAG + ":" + "isSchemaCompliant", clazz.getSimpleName() + " does not contain all required fields.");
            for (String[] param : params) {
                Logger.warn(TAG + ":" + "isSchemaCompliant", param[0] + " is null? [" + StringUtil.isNullOrEmpty(param[1]) + "]");
            }
        }
        return isCompliant;
    }

    private boolean isAccountSchemaCompliant(@NonNull AccountRecord account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        String[][] params = new String[][]{{"home_account_id", account.getHomeAccountId()}, {"environment", account.getEnvironment()}, {"local_account_id", account.getLocalAccountId()}, {"username", account.getUsername()}, {"authority_type", account.getAuthorityType()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(account.getClass(), params);
    }

    boolean isAccessTokenSchemaCompliant(@NonNull AccessTokenRecord accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String[][] params = new String[][]{{"credential_type", accessToken.getCredentialType()}, {"home_account_id", accessToken.getHomeAccountId()}, {"environment", accessToken.getEnvironment()}, {"client_id", accessToken.getClientId()}, {"target", accessToken.getTarget()}, {"cached_at", accessToken.getCachedAt()}, {"expires_on", accessToken.getExpiresOn()}, {"secret", accessToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(accessToken.getClass(), params);
    }

    private boolean isRefreshTokenSchemaCompliant(@NonNull RefreshTokenRecord refreshToken) {
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        String[][] params = new String[][]{{"credential_type", refreshToken.getCredentialType()}, {"environment", refreshToken.getEnvironment()}, {"home_account_id", refreshToken.getHomeAccountId()}, {"client_id", refreshToken.getClientId()}, {"secret", refreshToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(refreshToken.getClass(), params);
    }

    private boolean isIdTokenSchemaCompliant(@NonNull IdTokenRecord idToken) {
        if (idToken == null) {
            throw new NullPointerException("idToken is marked non-null but is null");
        }
        String[][] params = new String[][]{{"home_account_id", idToken.getHomeAccountId()}, {"environment", idToken.getEnvironment()}, {"credential_type", idToken.getCredentialType()}, {"client_id", idToken.getClientId()}, {"secret", idToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(idToken.getClass(), params);
    }

    protected IAccountCredentialCache getAccountCredentialCache() {
        return this.mAccountCredentialCache;
    }

    IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> getAccountCredentialAdapter() {
        return this.mAccountCredentialAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSingleSignOnState(GenericAccount account, GenericRefreshToken refreshToken) throws ClientException {
        Logger.info(TAG + ":setSingleSignOnState", "Set SSO state called.");
        AccountRecord accountDto = this.mAccountCredentialAdapter.asAccount(account);
        RefreshTokenRecord rt = this.mAccountCredentialAdapter.asRefreshToken(refreshToken);
        IdTokenRecord idToken = this.mAccountCredentialAdapter.asIdToken(account, refreshToken);
        this.validateCacheArtifacts(accountDto, null, rt, idToken);
        this.saveAccounts(accountDto);
        Object object = sCacheLock;
        synchronized (object) {
            this.saveCredentialsInternal(idToken, rt);
            this.removeAllRefreshTokensExcept(accountDto, rt);
        }
    }

    @Override
    public GenericRefreshToken getSingleSignOnState(GenericAccount account) {
        throw new UnsupportedOperationException("Unimplemented!");
    }
}

