/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.challengehandlers;

import com.microsoft.identity.common.java.AuthenticationSettings;
import com.microsoft.identity.common.java.challengehandlers.IDeviceCertificate;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.JWSBuilder;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PKeyAuthChallenge
implements Serializable {
    private static final String TAG = PKeyAuthChallenge.class.getSimpleName();
    private final String mNonce;
    private final String mContext;
    private final List<String> mCertAuthorities;
    private final String mThumbprint;
    private final String mVersion;
    private final String mSubmitUrl;

    protected PKeyAuthChallenge(Builder builder) {
        this.mNonce = builder.mNonce;
        this.mContext = builder.mContext;
        this.mCertAuthorities = builder.mCertAuthorities;
        this.mThumbprint = builder.mThumbprint;
        this.mVersion = builder.mVersion;
        this.mSubmitUrl = builder.mSubmitUrl;
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getContext() {
        return this.mContext;
    }

    public List<String> getCertAuthorities() {
        return this.mCertAuthorities;
    }

    public String getThumbprint() {
        return this.mThumbprint;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getSubmitUrl() {
        return this.mSubmitUrl;
    }

    public Map<String, String> getChallengeHeader() throws ClientException {
        IDeviceCertificate deviceCertProxy;
        String methodName = ":getChallengeHeader";
        String authorizationHeaderValue = String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", this.mContext, this.mVersion);
        Class<IDeviceCertificate> certClazz = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        if (certClazz != null && ((deviceCertProxy = PKeyAuthChallenge.getWPJAPIInstance(certClazz)).isValidIssuer(this.mCertAuthorities) || StringUtil.equalsIgnoreCase(deviceCertProxy.getThumbPrint(), this.mThumbprint))) {
            PrivateKey privateKey = deviceCertProxy.getPrivateKey();
            if (privateKey == null) {
                throw new ClientException("Key Chain private key exception");
            }
            PublicKey publicKey = deviceCertProxy.getPublicKey();
            X509Certificate certificate = deviceCertProxy.getCertificate();
            if (certificate == null) {
                throw new ClientException("Key Chain certificate exception");
            }
            String jwt = new JWSBuilder().generateSignedJWT(this.mNonce, this.mSubmitUrl, privateKey, publicKey, certificate);
            authorizationHeaderValue = String.format("%s AuthToken=\"%s\",Context=\"%s\",Version=\"%s\"", "PKeyAuth", jwt, this.mContext, this.mVersion);
            Logger.info(TAG + ":getChallengeHeader", "Receive challenge response. ");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authorizationHeaderValue);
        return headers;
    }

    private static IDeviceCertificate getWPJAPIInstance(@NonNull Class<IDeviceCertificate> certClazz) throws ClientException {
        IDeviceCertificate deviceCertProxy;
        try {
            Constructor<IDeviceCertificate> constructor = certClazz.getDeclaredConstructor(new Class[0]);
            deviceCertProxy = constructor.newInstance(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClientException("Device certificate API has exception", "WPJ Api constructor is not defined", e);
        }
        return deviceCertProxy;
    }

    public static class Builder {
        private String mNonce = "";
        private String mContext = "";
        private List<String> mCertAuthorities;
        private String mThumbprint = "";
        private String mVersion;
        private String mSubmitUrl;

        public Builder setNonce(String nonce) {
            this.mNonce = nonce;
            return this.self();
        }

        public Builder setContext(String context) {
            this.mContext = context;
            return this.self();
        }

        public Builder setCertAuthorities(List<String> certAuthorities) {
            this.mCertAuthorities = certAuthorities;
            return this.self();
        }

        public Builder setThumbprint(String thumbprint) {
            this.mThumbprint = thumbprint;
            return this.self();
        }

        public Builder setVersion(String version) {
            this.mVersion = version;
            return this.self();
        }

        public Builder setSubmitUrl(String submitUrl) {
            this.mSubmitUrl = submitUrl;
            return this.self();
        }

        public Builder self() {
            return this;
        }

        public PKeyAuthChallenge build() {
            return new PKeyAuthChallenge(this);
        }
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint;

    }
}

