/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.challengehandlers;

import com.microsoft.identity.common.java.AuthenticationSettings;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class PKeyAuthChallengeFactory {
    private static final String TAG = PKeyAuthChallengeFactory.class.getSimpleName();
    private static final String CHALLENGE_REQUEST_CERT_AUTH_DELIMITER = ";";

    public PKeyAuthChallenge getPKeyAuthChallenge(@NonNull String redirectUri) throws ClientException {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        Map<String, String> parameters = UrlUtil.getParameters(redirectUri);
        this.validatePKeyAuthChallenge(parameters);
        PKeyAuthChallenge.Builder builder = new PKeyAuthChallenge.Builder();
        builder.setNonce(parameters.get(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))).setContext(parameters.get(PKeyAuthChallenge.RequestField.Context.name())).setCertAuthorities(StringUtil.getStringTokens(parameters.get(PKeyAuthChallenge.RequestField.CertAuthorities.name()), CHALLENGE_REQUEST_CERT_AUTH_DELIMITER)).setVersion(parameters.get(PKeyAuthChallenge.RequestField.Version.name())).setSubmitUrl(parameters.get(PKeyAuthChallenge.RequestField.SubmitUrl.name()));
        return builder.build();
    }

    public PKeyAuthChallenge getPKeyAuthChallenge(@NonNull String header, @NonNull String authority) throws ClientException, UnsupportedEncodingException {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        this.validateHeaderForPkeyAuthChallenge(header);
        Map<String, String> headerItems = this.getPKeyAuthHeader(header);
        this.validatePKeyAuthChallenge(headerItems);
        PKeyAuthChallenge.Builder builder = new PKeyAuthChallenge.Builder();
        builder.setSubmitUrl(authority).setNonce(headerItems.get(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))).setVersion(headerItems.get(PKeyAuthChallenge.RequestField.Version.name())).setContext(headerItems.get(PKeyAuthChallenge.RequestField.Context.name()));
        if (!this.isWorkplaceJoined()) {
            Logger.info(TAG, "Device is not workplace joined. ");
        } else if (!StringUtil.isNullOrEmpty(headerItems.get(PKeyAuthChallenge.RequestField.CertThumbprint.name()))) {
            Logger.info(TAG, "CertThumbprint exists in the device auth challenge.");
            builder.setThumbprint(headerItems.get(PKeyAuthChallenge.RequestField.CertThumbprint.name()));
        } else if (headerItems.containsKey(PKeyAuthChallenge.RequestField.CertAuthorities.name())) {
            Logger.info(TAG, "CertAuthorities exists in the device auth challenge.");
            String authorities = headerItems.get(PKeyAuthChallenge.RequestField.CertAuthorities.name());
            builder.setCertAuthorities(StringUtil.getStringTokens(authorities, CHALLENGE_REQUEST_CERT_AUTH_DELIMITER));
        } else {
            throw new ClientException("Device certificate request is invalid", "Both certThumbprint and cert authorities are not present");
        }
        return builder.build();
    }

    private boolean isWorkplaceJoined() {
        Class<?> certClass = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        return certClass != null;
    }

    private void validateHeaderForPkeyAuthChallenge(@NonNull String header) throws ClientException {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (StringUtil.isNullOrEmpty(header)) {
            throw new ClientException("Device certificate request is invalid", "header value is empty.");
        }
        if (!StringUtil.hasPrefixInHeader(header, "PKeyAuth")) {
            throw new ClientException("Device certificate request is invalid", "challenge response type is wrong.");
        }
    }

    private void validatePKeyAuthChallenge(Map<String, String> headerItems) throws ClientException {
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name()) && !headerItems.containsKey(PKeyAuthChallenge.RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new ClientException("Device certificate request is invalid", "Nonce is empty.");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Version.name())) {
            throw new ClientException("Device certificate request is invalid", "Version name is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.SubmitUrl.name())) {
            throw new ClientException("Device certificate request is invalid", "SubmitUrl is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.Context.name())) {
            throw new ClientException("Device certificate request is invalid", "Context is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallenge.RequestField.CertAuthorities.name())) {
            throw new ClientException("Device certificate request is invalid", "CertAuthorities is empty");
        }
    }

    private Map<String, String> getPKeyAuthHeader(String headerStr) throws ClientException, UnsupportedEncodingException {
        String authenticateHeader = headerStr.substring("PKeyAuth".length());
        ArrayList<String> queryPairs = StringUtil.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = StringUtil.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringUtil.isNullOrEmpty(pair.get(0)) && !StringUtil.isNullOrEmpty(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                key = StringUtil.urlFormDecode(key);
                value = StringUtil.urlFormDecode(value);
                key = key.trim();
                value = StringUtil.removeQuoteInHeaderValue(value.trim());
                headerItems.put(key, value);
                continue;
            }
            if (pair.size() == 1 && !StringUtil.isNullOrEmpty(pair.get(0))) {
                headerItems.put(StringUtil.urlFormDecode(pair.get(0)).trim(), StringUtil.urlFormDecode(""));
                continue;
            }
            throw new ClientException("Device certificate request is invalid", authenticateHeader);
        }
        return headerItems;
    }
}

