/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.microsoft.identity.common.java.broker.IBrokerAccount;
import com.microsoft.identity.common.java.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.util.StringUtil;

public class BrokerSilentTokenCommandParameters
extends SilentTokenCommandParameters {
    private final String callerPackageName;
    private final int callerUid;
    private final String callerAppVersion;
    private final String brokerVersion;
    private final IBrokerAccount brokerAccount;
    private final String homeAccountId;
    private final String localAccountId;
    private final int sleepTimeBeforePrtAcquisition;
    private final String negotiatedBrokerProtocolVersion;

    @Override
    public void validate() throws ArgumentException {
        if (this.callerUid == 0) {
            throw new ArgumentException("acquireTokenSilent", "mCallerUId", "Caller Uid is not set");
        }
        if (StringUtil.isNullOrEmpty(this.callerPackageName)) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Caller package name is not set");
        }
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireTokenSilent", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireTokenSilent", "mScopes", "Scope or resource is not set");
        }
        if (StringUtil.isNullOrEmpty(this.getClientId())) {
            throw new ArgumentException("acquireTokenSilent", "mClientId", "Client Id is not set");
        }
        if (StringUtil.isNullOrEmpty(this.callerPackageName)) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Caller package name is not set");
        }
        if (this.getSdkType().isCapableOfMSA() && !this.getPlatformComponents().getPlatformUtil().isValidCallingApp(this.getRedirectUri(), this.getCallerPackageName())) {
            throw new ArgumentException("acquireTokenSilent", "mRedirectUri", "The redirect URI doesn't match the uri generated with caller package name and signature");
        }
        if (!(this.getOAuth2TokenCache() instanceof BrokerOAuth2TokenCache)) {
            throw new ArgumentException("acquireTokenSilent", "AcquireTokenSilentOperationParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
        }
        if (null == this.brokerAccount) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Broker Account is null");
        }
    }

    protected BrokerSilentTokenCommandParameters(BrokerSilentTokenCommandParametersBuilder<?, ?> b) {
        super((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder<?, ?>)b);
        this.callerPackageName = ((BrokerSilentTokenCommandParametersBuilder)b).callerPackageName;
        this.callerUid = ((BrokerSilentTokenCommandParametersBuilder)b).callerUid;
        this.callerAppVersion = ((BrokerSilentTokenCommandParametersBuilder)b).callerAppVersion;
        this.brokerVersion = ((BrokerSilentTokenCommandParametersBuilder)b).brokerVersion;
        this.brokerAccount = ((BrokerSilentTokenCommandParametersBuilder)b).brokerAccount;
        this.homeAccountId = ((BrokerSilentTokenCommandParametersBuilder)b).homeAccountId;
        this.localAccountId = ((BrokerSilentTokenCommandParametersBuilder)b).localAccountId;
        this.sleepTimeBeforePrtAcquisition = ((BrokerSilentTokenCommandParametersBuilder)b).sleepTimeBeforePrtAcquisition;
        this.negotiatedBrokerProtocolVersion = ((BrokerSilentTokenCommandParametersBuilder)b).negotiatedBrokerProtocolVersion;
    }

    public static BrokerSilentTokenCommandParametersBuilder<?, ?> builder() {
        return new BrokerSilentTokenCommandParametersBuilderImpl();
    }

    @Override
    public BrokerSilentTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new BrokerSilentTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public String getCallerPackageName() {
        return this.callerPackageName;
    }

    public int getCallerUid() {
        return this.callerUid;
    }

    public String getCallerAppVersion() {
        return this.callerAppVersion;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public IBrokerAccount getBrokerAccount() {
        return this.brokerAccount;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getLocalAccountId() {
        return this.localAccountId;
    }

    public int getSleepTimeBeforePrtAcquisition() {
        return this.sleepTimeBeforePrtAcquisition;
    }

    public String getNegotiatedBrokerProtocolVersion() {
        return this.negotiatedBrokerProtocolVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerSilentTokenCommandParameters)) {
            return false;
        }
        BrokerSilentTokenCommandParameters other = (BrokerSilentTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$callerPackageName = this.getCallerPackageName();
        String other$callerPackageName = other.getCallerPackageName();
        if (this$callerPackageName == null ? other$callerPackageName != null : !this$callerPackageName.equals(other$callerPackageName)) {
            return false;
        }
        if (this.getCallerUid() != other.getCallerUid()) {
            return false;
        }
        String this$callerAppVersion = this.getCallerAppVersion();
        String other$callerAppVersion = other.getCallerAppVersion();
        if (this$callerAppVersion == null ? other$callerAppVersion != null : !this$callerAppVersion.equals(other$callerAppVersion)) {
            return false;
        }
        String this$brokerVersion = this.getBrokerVersion();
        String other$brokerVersion = other.getBrokerVersion();
        if (this$brokerVersion == null ? other$brokerVersion != null : !this$brokerVersion.equals(other$brokerVersion)) {
            return false;
        }
        IBrokerAccount this$brokerAccount = this.getBrokerAccount();
        IBrokerAccount other$brokerAccount = other.getBrokerAccount();
        if (this$brokerAccount == null ? other$brokerAccount != null : !this$brokerAccount.equals(other$brokerAccount)) {
            return false;
        }
        String this$homeAccountId = this.getHomeAccountId();
        String other$homeAccountId = other.getHomeAccountId();
        if (this$homeAccountId == null ? other$homeAccountId != null : !this$homeAccountId.equals(other$homeAccountId)) {
            return false;
        }
        String this$localAccountId = this.getLocalAccountId();
        String other$localAccountId = other.getLocalAccountId();
        if (this$localAccountId == null ? other$localAccountId != null : !this$localAccountId.equals(other$localAccountId)) {
            return false;
        }
        if (this.getSleepTimeBeforePrtAcquisition() != other.getSleepTimeBeforePrtAcquisition()) {
            return false;
        }
        String this$negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        String other$negotiatedBrokerProtocolVersion = other.getNegotiatedBrokerProtocolVersion();
        return !(this$negotiatedBrokerProtocolVersion == null ? other$negotiatedBrokerProtocolVersion != null : !this$negotiatedBrokerProtocolVersion.equals(other$negotiatedBrokerProtocolVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerSilentTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $callerPackageName = this.getCallerPackageName();
        result = result * 59 + ($callerPackageName == null ? 43 : $callerPackageName.hashCode());
        result = result * 59 + this.getCallerUid();
        String $callerAppVersion = this.getCallerAppVersion();
        result = result * 59 + ($callerAppVersion == null ? 43 : $callerAppVersion.hashCode());
        String $brokerVersion = this.getBrokerVersion();
        result = result * 59 + ($brokerVersion == null ? 43 : $brokerVersion.hashCode());
        IBrokerAccount $brokerAccount = this.getBrokerAccount();
        result = result * 59 + ($brokerAccount == null ? 43 : $brokerAccount.hashCode());
        String $homeAccountId = this.getHomeAccountId();
        result = result * 59 + ($homeAccountId == null ? 43 : $homeAccountId.hashCode());
        String $localAccountId = this.getLocalAccountId();
        result = result * 59 + ($localAccountId == null ? 43 : $localAccountId.hashCode());
        result = result * 59 + this.getSleepTimeBeforePrtAcquisition();
        String $negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        result = result * 59 + ($negotiatedBrokerProtocolVersion == null ? 43 : $negotiatedBrokerProtocolVersion.hashCode());
        return result;
    }

    private static final class BrokerSilentTokenCommandParametersBuilderImpl
    extends BrokerSilentTokenCommandParametersBuilder<BrokerSilentTokenCommandParameters, BrokerSilentTokenCommandParametersBuilderImpl> {
        private BrokerSilentTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected BrokerSilentTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public BrokerSilentTokenCommandParameters build() {
            return new BrokerSilentTokenCommandParameters(this);
        }
    }

    public static abstract class BrokerSilentTokenCommandParametersBuilder<C extends BrokerSilentTokenCommandParameters, B extends BrokerSilentTokenCommandParametersBuilder<C, B>>
    extends SilentTokenCommandParameters.SilentTokenCommandParametersBuilder<C, B> {
        private String callerPackageName;
        private int callerUid;
        private String callerAppVersion;
        private String brokerVersion;
        private IBrokerAccount brokerAccount;
        private String homeAccountId;
        private String localAccountId;
        private int sleepTimeBeforePrtAcquisition;
        private String negotiatedBrokerProtocolVersion;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrokerSilentTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrokerSilentTokenCommandParameters instance, BrokerSilentTokenCommandParametersBuilder<?, ?> b) {
            b.callerPackageName(instance.callerPackageName);
            b.callerUid(instance.callerUid);
            b.callerAppVersion(instance.callerAppVersion);
            b.brokerVersion(instance.brokerVersion);
            b.brokerAccount(instance.brokerAccount);
            b.homeAccountId(instance.homeAccountId);
            b.localAccountId(instance.localAccountId);
            b.sleepTimeBeforePrtAcquisition(instance.sleepTimeBeforePrtAcquisition);
            b.negotiatedBrokerProtocolVersion(instance.negotiatedBrokerProtocolVersion);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B callerPackageName(String callerPackageName) {
            this.callerPackageName = callerPackageName;
            return (B)this.self();
        }

        public B callerUid(int callerUid) {
            this.callerUid = callerUid;
            return (B)this.self();
        }

        public B callerAppVersion(String callerAppVersion) {
            this.callerAppVersion = callerAppVersion;
            return (B)this.self();
        }

        public B brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return (B)this.self();
        }

        public B brokerAccount(IBrokerAccount brokerAccount) {
            this.brokerAccount = brokerAccount;
            return (B)this.self();
        }

        public B homeAccountId(String homeAccountId) {
            this.homeAccountId = homeAccountId;
            return (B)this.self();
        }

        public B localAccountId(String localAccountId) {
            this.localAccountId = localAccountId;
            return (B)this.self();
        }

        public B sleepTimeBeforePrtAcquisition(int sleepTimeBeforePrtAcquisition) {
            this.sleepTimeBeforePrtAcquisition = sleepTimeBeforePrtAcquisition;
            return (B)this.self();
        }

        public B negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.negotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder(super=" + super.toString() + ", callerPackageName=" + this.callerPackageName + ", callerUid=" + this.callerUid + ", callerAppVersion=" + this.callerAppVersion + ", brokerVersion=" + this.brokerVersion + ", brokerAccount=" + this.brokerAccount + ", homeAccountId=" + this.homeAccountId + ", localAccountId=" + this.localAccountId + ", sleepTimeBeforePrtAcquisition=" + this.sleepTimeBeforePrtAcquisition + ", negotiatedBrokerProtocolVersion=" + this.negotiatedBrokerProtocolVersion + ")";
        }
    }
}

