/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.controllers;

import com.google.gson.JsonSyntaxException;
import com.microsoft.identity.common.java.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.DeviceRegistrationRequiredException;
import com.microsoft.identity.common.java.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.TerminalException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.telemetry.CliTelemInfo;
import com.microsoft.identity.common.java.util.HeaderSerializationUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.json.JSONException;

public class ExceptionAdapter {
    private static final String TAG = ExceptionAdapter.class.getSimpleName();

    @Nullable
    public static BaseException exceptionFromAcquireTokenResult(AcquireTokenResult result, CommandParameters commandParameters) {
        String methodName = ":exceptionFromAcquireTokenResult";
        AuthorizationResult authorizationResult = result.getAuthorizationResult();
        if (null != authorizationResult) {
            Object authorizationErrorResponse = authorizationResult.getAuthorizationErrorResponse();
            if (!authorizationResult.getSuccess()) {
                switch (result.getAuthorizationResult().getAuthorizationStatus()) {
                    case FAIL: {
                        MicrosoftAuthorizationErrorResponse microsoftAuthorizationErrorResponse;
                        if (authorizationErrorResponse instanceof MicrosoftAuthorizationErrorResponse && (microsoftAuthorizationErrorResponse = (MicrosoftAuthorizationErrorResponse)authorizationErrorResponse).getError().equals("device_registration_needed")) {
                            return new DeviceRegistrationRequiredException(microsoftAuthorizationErrorResponse.getError(), microsoftAuthorizationErrorResponse.getErrorDescription(), microsoftAuthorizationErrorResponse.getUpnToWpj());
                        }
                        return new ServiceException(((AuthorizationErrorResponse)authorizationErrorResponse).getError(), ((AuthorizationErrorResponse)authorizationErrorResponse).getErrorDescription(), 0, null);
                    }
                    case SDK_CANCEL: {
                        return new ClientException(((AuthorizationErrorResponse)authorizationErrorResponse).getError(), ((AuthorizationErrorResponse)authorizationErrorResponse).getErrorDescription());
                    }
                    case USER_CANCEL: {
                        return new UserCancelException();
                    }
                }
            }
        } else {
            Logger.warn(TAG + ":exceptionFromAcquireTokenResult", "AuthorizationResult was null -- expected for ATS cases.");
        }
        return ExceptionAdapter.exceptionFromTokenResult(result.getTokenResult(), commandParameters);
    }

    public static ServiceException exceptionFromTokenResult(TokenResult tokenResult, CommandParameters commandParameters) {
        ServiceException outErr;
        String methodName = ":exceptionFromTokenResult";
        if (tokenResult != null && !tokenResult.getSuccess() && tokenResult.getErrorResponse() != null && !StringUtil.isNullOrEmpty(tokenResult.getErrorResponse().getError())) {
            outErr = ExceptionAdapter.getExceptionFromTokenErrorResponse(commandParameters, tokenResult.getErrorResponse());
            ExceptionAdapter.applyCliTelemInfo(tokenResult.getCliTelemInfo(), outErr);
        } else {
            Logger.warn(TAG + ":exceptionFromTokenResult", "Unknown error, Token result is null [" + (tokenResult == null) + "]");
            outErr = new ServiceException("unknown_error", "Request failed, but no error returned back from service.", null);
        }
        return outErr;
    }

    private static boolean shouldBeConvertedToUiRequiredException(String oAuthError) {
        return "invalid_grant".equalsIgnoreCase(oAuthError) || "interaction_required".equalsIgnoreCase(oAuthError);
    }

    public static ServiceException getExceptionFromTokenErrorResponse(@NonNull TokenErrorResponse errorResponse) {
        if (errorResponse == null) {
            throw new NullPointerException("errorResponse is marked non-null but is null");
        }
        ServiceException outErr = ExceptionAdapter.shouldBeConvertedToUiRequiredException(errorResponse.getError()) ? new UiRequiredException(errorResponse.getError(), errorResponse.getErrorDescription()) : new ServiceException(errorResponse.getError(), errorResponse.getErrorDescription(), null);
        outErr.setOauthSubErrorCode(errorResponse.getSubError());
        ExceptionAdapter.setHttpResponseUsingTokenErrorResponse(outErr, errorResponse);
        return outErr;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public static ServiceException getExceptionFromTokenErrorResponse(@Nullable CommandParameters commandParameters, @NonNull TokenErrorResponse errorResponse) {
        if (errorResponse == null) {
            throw new NullPointerException("errorResponse is marked non-null but is null");
        }
        if (ExceptionAdapter.isIntunePolicyRequiredError(errorResponse)) {
            if (commandParameters == null || !ExceptionAdapter.isBrokerTokenCommandParameters(commandParameters)) {
                Logger.warn(TAG, "In order to properly construct the IntuneAppProtectionPolicyRequiredException we need the command parameters to be supplied.  Returning as service exception instead.");
                return ExceptionAdapter.getExceptionFromTokenErrorResponse(errorResponse);
            }
            IntuneAppProtectionPolicyRequiredException policyRequiredException = commandParameters instanceof BrokerInteractiveTokenCommandParameters ? new IntuneAppProtectionPolicyRequiredException(errorResponse.getError(), errorResponse.getErrorDescription(), (BrokerInteractiveTokenCommandParameters)commandParameters) : new IntuneAppProtectionPolicyRequiredException(errorResponse.getError(), errorResponse.getErrorDescription(), (BrokerSilentTokenCommandParameters)commandParameters);
            policyRequiredException.setOauthSubErrorCode(errorResponse.getSubError());
            ExceptionAdapter.setHttpResponseUsingTokenErrorResponse(policyRequiredException, errorResponse);
            return policyRequiredException;
        }
        return ExceptionAdapter.getExceptionFromTokenErrorResponse(errorResponse);
    }

    private static void setHttpResponseUsingTokenErrorResponse(@NonNull ServiceException exception, @NonNull TokenErrorResponse errorResponse) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        if (errorResponse == null) {
            throw new NullPointerException("errorResponse is marked non-null but is null");
        }
        try {
            exception.setHttpResponse(ExceptionAdapter.synthesizeHttpResponse(errorResponse.getStatusCode(), errorResponse.getResponseHeadersJson(), errorResponse.getResponseBody()));
        }
        catch (JSONException e) {
            Logger.warn(TAG, "Failed to deserialize error data: status, headers, response body.");
        }
    }

    private static boolean isBrokerTokenCommandParameters(CommandParameters commandParameters) {
        return commandParameters instanceof BrokerSilentTokenCommandParameters || commandParameters instanceof BrokerInteractiveTokenCommandParameters;
    }

    public static void applyCliTelemInfo(@Nullable CliTelemInfo cliTelemInfo, @NonNull BaseException outErr) {
        if (outErr == null) {
            throw new NullPointerException("outErr is marked non-null but is null");
        }
        if (null != cliTelemInfo) {
            outErr.setSpeRing(cliTelemInfo.getSpeRing());
            outErr.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
            outErr.setCliTelemErrorCode(cliTelemInfo.getServerErrorCode());
            outErr.setCliTelemSubErrorCode(cliTelemInfo.getServerSubErrorCode());
        }
    }

    private static HttpResponse synthesizeHttpResponse(int statusCode, @Nullable String responseHeadersJson, @Nullable String responseBody) {
        String methodName = ":applyHttpErrorResponseData";
        if (null != responseHeadersJson && null != responseBody) {
            try {
                return new HttpResponse(statusCode, responseBody, HeaderSerializationUtil.fromJson(responseHeadersJson));
            }
            catch (JsonSyntaxException e) {
                Logger.warn(TAG + ":applyHttpErrorResponseData", "Failed to deserialize error data: status, headers, response body.");
            }
        }
        return null;
    }

    public static BaseException baseExceptionFromException(Throwable exception) {
        Throwable e = exception;
        if (exception instanceof ExecutionException) {
            e = exception.getCause();
        }
        if (e instanceof TerminalException) {
            String errorCode = ((TerminalException)e).getErrorCode();
            e = e.getCause();
            return new ClientException(errorCode, "An unhandled exception occurred with message: " + e.getMessage(), e);
        }
        if (e instanceof IOException) {
            return new ClientException("io_error", "An IO error occurred with message: " + e.getMessage(), e);
        }
        if (e instanceof BaseException) {
            return (BaseException)e;
        }
        return new ClientException("unknown_error", e.getMessage(), e);
    }

    private static boolean isIntunePolicyRequiredError(@NonNull TokenErrorResponse errorResponse) {
        if (errorResponse == null) {
            throw new NullPointerException("errorResponse is marked non-null but is null");
        }
        return !StringUtil.isNullOrEmpty(errorResponse.getError()) && !StringUtil.isNullOrEmpty(errorResponse.getSubError()) && errorResponse.getError().equalsIgnoreCase("unauthorized_client") && errorResponse.getSubError().equalsIgnoreCase("protection_policy_required");
    }
}

