/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ISigner;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class BasicSigner
implements ISigner {
    private static final String TAG = BasicSigner.class.getSimpleName();

    @Override
    public byte[] sign(@NonNull PrivateKey key, @NonNull String signingAlgorithm, byte[] dataToBeSigned) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (signingAlgorithm == null) {
            throw new NullPointerException("signingAlgorithm is marked non-null but is null");
        }
        try {
            Signature signer = Signature.getInstance(signingAlgorithm);
            signer.initSign(key);
            signer.update(dataToBeSigned);
            return signer.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new ClientException("failed_to_sign", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
    }

    @Override
    public byte[] signWithHMac(byte[] keyData, @NonNull String hmacAlgorithm, byte[] dataToBeSigned) throws ClientException {
        if (hmacAlgorithm == null) {
            throw new NullPointerException("hmacAlgorithm is marked non-null but is null");
        }
        String methodName = "signWithDerivedKey";
        try {
            Mac sha256HMAC = Mac.getInstance(hmacAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(keyData, hmacAlgorithm);
            sha256HMAC.init(secretKey);
            return sha256HMAC.doFinal(dataToBeSigned);
        }
        catch (NoSuchAlgorithmException e) {
            String errorString = hmacAlgorithm + " algorithm does not exist " + e.getMessage();
            Logger.error(TAG + "signWithDerivedKey", errorString, e);
            throw new ClientException("no_such_algorithm", errorString, e);
        }
        catch (IllegalStateException e) {
            Logger.error(TAG + "signWithDerivedKey", e.getMessage(), e);
            throw new ClientException("encryption_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            String errorString = "Key is invalid for signing " + e.getMessage();
            Logger.error(TAG + "signWithDerivedKey", errorString, e);
            throw new ClientException("invalid_key", errorString, e);
        }
    }
}

