/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.exception.ClientException;
import lombok.NonNull;

public class KeyAccessorStringAdapter {
    private final IKeyAccessor mKeyAcccesor;

    public String encrypt(@NonNull String plainText) throws ClientException {
        if (plainText == null) {
            throw new NullPointerException("plainText is marked non-null but is null");
        }
        byte[] result = this.mKeyAcccesor.encrypt(plainText.getBytes(AuthenticationConstants.ENCODING_UTF8));
        return new String(result, AuthenticationConstants.ENCODING_UTF8);
    }

    public String decrypt(@NonNull String cipherText) throws ClientException {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        byte[] result = this.mKeyAcccesor.decrypt(cipherText.getBytes(AuthenticationConstants.ENCODING_UTF8));
        return new String(result, AuthenticationConstants.ENCODING_UTF8);
    }

    public KeyAccessorStringAdapter(IKeyAccessor mKeyAcccesor) {
        this.mKeyAcccesor = mKeyAcccesor;
    }
}

