/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.eststelemetry;

import com.microsoft.identity.common.java.commands.ICommand;
import com.microsoft.identity.common.java.commands.ICommandResult;
import com.microsoft.identity.common.java.eststelemetry.CurrentRequestTelemetry;
import com.microsoft.identity.common.java.eststelemetry.FailedRequest;
import com.microsoft.identity.common.java.eststelemetry.LastRequestTelemetry;
import com.microsoft.identity.common.java.eststelemetry.LastRequestTelemetryCache;
import com.microsoft.identity.common.java.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.java.eststelemetry.TelemetryUtils;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.InMemoryStorage;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class EstsTelemetry {
    private static final String TAG = EstsTelemetry.class.getSimpleName();
    private static final String LAST_REQUEST_TELEMETRY_STORAGE_FILE = "com.microsoft.identity.client.last_request_telemetry";
    private static volatile EstsTelemetry sEstsTelemetryInstance = null;
    private LastRequestTelemetryCache mLastRequestTelemetryCache;
    private final INameValueStorage<CurrentRequestTelemetry> mTelemetryMap;
    private final INameValueStorage<Set<FailedRequest>> mSentFailedRequests;

    EstsTelemetry() {
        this(new InMemoryStorage<CurrentRequestTelemetry>(), new InMemoryStorage<Set<FailedRequest>>());
    }

    EstsTelemetry(@NonNull INameValueStorage<CurrentRequestTelemetry> telemetryMap, @NonNull INameValueStorage<Set<FailedRequest>> sentFailedRequestsMap) {
        if (telemetryMap == null) {
            throw new NullPointerException("telemetryMap is marked non-null but is null");
        }
        if (sentFailedRequestsMap == null) {
            throw new NullPointerException("sentFailedRequestsMap is marked non-null but is null");
        }
        this.mTelemetryMap = telemetryMap;
        this.mSentFailedRequests = sentFailedRequestsMap;
    }

    public static synchronized EstsTelemetry getInstance() {
        if (sEstsTelemetryInstance == null) {
            sEstsTelemetryInstance = new EstsTelemetry();
        }
        return sEstsTelemetryInstance;
    }

    public synchronized void clear() {
        this.mTelemetryMap.clear();
        this.mSentFailedRequests.clear();
        if (this.mLastRequestTelemetryCache != null) {
            this.mLastRequestTelemetryCache.clear();
        }
    }

    public synchronized void setUp(@NonNull LastRequestTelemetryCache lastRequestTelemetryCache) {
        if (lastRequestTelemetryCache == null) {
            throw new NullPointerException("lastRequestTelemetryCache is marked non-null but is null");
        }
        if (this.mLastRequestTelemetryCache == null) {
            this.mLastRequestTelemetryCache = lastRequestTelemetryCache;
        }
    }

    public synchronized void setUp(@NonNull IPlatformComponents platformComponents) {
        if (platformComponents == null) {
            throw new NullPointerException("platformComponents is marked non-null but is null");
        }
        if (this.mLastRequestTelemetryCache == null) {
            this.mLastRequestTelemetryCache = new LastRequestTelemetryCache(platformComponents.getNameValueStore(LAST_REQUEST_TELEMETRY_STORAGE_FILE, String.class));
        }
    }

    public void initTelemetryForCommand(@NonNull ICommand<?> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (command.isEligibleForEstsTelemetry()) {
            CurrentRequestTelemetry currentRequestTelemetry = new CurrentRequestTelemetry();
            this.mTelemetryMap.put(command.getCorrelationId(), currentRequestTelemetry);
            this.mSentFailedRequests.put(command.getCorrelationId(), new HashSet());
        }
    }

    public void emit(Map<String, String> telemetry) {
        if (telemetry == null) {
            return;
        }
        for (Map.Entry<String, String> entry : telemetry.entrySet()) {
            this.emit(entry.getKey(), entry.getValue());
        }
    }

    public void emit(String key, String value) {
        if (StringUtil.isNullOrEmpty(key)) {
            return;
        }
        String correlationId = (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id");
        String compliantValueString = TelemetryUtils.getSchemaCompliantString(value);
        CurrentRequestTelemetry currentTelemetryInstance = this.getCurrentTelemetryInstance(correlationId);
        if (currentTelemetryInstance != null) {
            currentTelemetryInstance.put(key, compliantValueString);
        }
    }

    public void emitApiId(String apiId) {
        this.emit("Microsoft.MSAL.api_id", apiId);
    }

    public void emitForceRefresh(boolean forceRefresh) {
        String val = TelemetryUtils.getSchemaCompliantStringFromBoolean(forceRefresh);
        this.emit("Microsoft.MSAL.force_refresh", val);
    }

    public synchronized void flush(@NonNull ICommand<?> command, @NonNull ICommandResult commandResult) {
        ILocalAuthenticationResult localAuthenticationResult;
        String errorCode;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        String methodName = ":flush";
        String correlationId = command.getCorrelationId();
        if (correlationId == null) {
            Logger.info(TAG + ":flush", "correlation ID is null. Nothing to flush.");
            return;
        }
        CurrentRequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            Logger.info(TAG + ":flush", "currentTelemetry is null. Nothing to flush.");
            return;
        }
        LastRequestTelemetry lastRequestTelemetry = this.loadLastRequestTelemetryFromCache();
        if (lastRequestTelemetry == null) {
            lastRequestTelemetry = new LastRequestTelemetry(currentTelemetry.getSchemaVersion());
            lastRequestTelemetry = (LastRequestTelemetry)lastRequestTelemetry.copySharedValues(currentTelemetry);
        }
        if (this.isTelemetryLoggedByServer(command, commandResult)) {
            lastRequestTelemetry.resetSilentSuccessCount();
            Set<FailedRequest> failedRequestSentSet = this.mSentFailedRequests.get(correlationId);
            lastRequestTelemetry.wipeFailedRequestAndErrorForSubList(failedRequestSentSet);
        }
        if ((errorCode = this.getErrorCodeFromCommandResult(commandResult)) != null) {
            lastRequestTelemetry.appendFailedRequest(currentTelemetry.getApiId(), correlationId, errorCode);
        } else if (commandResult.getResult() != null && commandResult.getResult() instanceof ILocalAuthenticationResult && (localAuthenticationResult = (ILocalAuthenticationResult)commandResult.getResult()).isServicedFromCache()) {
            lastRequestTelemetry.incrementSilentSuccessCount();
        }
        this.mTelemetryMap.remove(correlationId);
        this.mSentFailedRequests.remove(correlationId);
        if (this.mLastRequestTelemetryCache != null) {
            this.mLastRequestTelemetryCache.saveRequestTelemetryToCache(lastRequestTelemetry);
        } else {
            Logger.warn(TAG + ":flush", "Last Request Telemetry Cache object was null. Unable to save request telemetry to cache.");
        }
    }

    @Nullable
    private LastRequestTelemetry loadLastRequestTelemetryFromCache() {
        String methodName = ":loadLastRequestTelemetry";
        if (this.mLastRequestTelemetryCache == null) {
            Logger.verbose(TAG + ":loadLastRequestTelemetry", "Last Request Telemetry Cache has not been initialized. Cannot load Last Request Telemetry data from cache.");
            return null;
        }
        return this.mLastRequestTelemetryCache.getRequestTelemetryFromCache();
    }

    @Nullable
    private String getErrorCodeFromCommandResult(@NonNull ICommandResult commandResult) {
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.ERROR) {
            BaseException baseException = (BaseException)commandResult.getResult();
            return baseException.getErrorCode();
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.CANCEL) {
            return "user_cancel";
        }
        return null;
    }

    private boolean isTelemetryLoggedByServer(@NonNull ICommand<?> command, @NonNull ICommandResult commandResult) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (commandResult == null) {
            throw new NullPointerException("commandResult is marked non-null but is null");
        }
        if (!command.willReachTokenEndpoint()) {
            return false;
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.ERROR) {
            BaseException baseException = (BaseException)commandResult.getResult();
            if (!(baseException instanceof ServiceException)) {
                return false;
            }
            ServiceException serviceException = (ServiceException)baseException;
            int statusCode = serviceException.getHttpStatusCode();
            return statusCode != 0 && statusCode != 429 && statusCode < 500;
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.CANCEL) {
            return false;
        }
        if (commandResult.getStatus() == ICommandResult.ResultStatus.COMPLETED) {
            if (commandResult.getResult() instanceof ILocalAuthenticationResult) {
                ILocalAuthenticationResult localAuthenticationResult = (ILocalAuthenticationResult)commandResult.getResult();
                if (localAuthenticationResult.isServicedFromCache()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private String getCurrentTelemetryHeaderString() {
        String methodName = ":getCurrentTelemetryHeaderString";
        String correlationId = (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id");
        if (correlationId == null) {
            Logger.warn(TAG + ":getCurrentTelemetryHeaderString", "correlation ID is null.");
            return null;
        }
        RequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            Logger.warn(TAG + ":getCurrentTelemetryHeaderString", "currentTelemetry for correlation ID:" + correlationId + " is null.");
            return null;
        }
        return currentTelemetry.getCompleteHeaderString();
    }

    @Nullable
    private synchronized String getLastTelemetryHeaderString() {
        String methodName = ":getLastTelemetryHeaderString";
        if (this.mLastRequestTelemetryCache == null) {
            Logger.warn(TAG + ":getLastTelemetryHeaderString", "mLastRequestTelemetryCache is null.");
            return null;
        }
        String correlationId = (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id");
        if (correlationId == null) {
            Logger.warn(TAG + ":getLastTelemetryHeaderString", "correlation ID is null.");
            return null;
        }
        LastRequestTelemetry lastRequestTelemetryFromCache = this.mLastRequestTelemetryCache.getRequestTelemetryFromCache();
        if (lastRequestTelemetryFromCache == null) {
            CurrentRequestTelemetry currentRequestTelemetry = this.mTelemetryMap.get(correlationId);
            if (currentRequestTelemetry == null) {
                Logger.warn(TAG + ":getLastTelemetryHeaderString", "currentTelemetry for correlation ID:" + correlationId + " is null.");
                return null;
            }
            LastRequestTelemetry lastRequestTelemetry = new LastRequestTelemetry(currentRequestTelemetry.getSchemaVersion());
            lastRequestTelemetry.copySharedValues(currentRequestTelemetry);
            lastRequestTelemetry.putInPlatformTelemetry("is_all_telemetry_data_sent", "1");
            return lastRequestTelemetry.getCompleteHeaderString();
        }
        LastRequestTelemetry lastRequestTelemetryCopy = new LastRequestTelemetry(lastRequestTelemetryFromCache.getSchemaVersion());
        lastRequestTelemetryCopy.copySharedValues(lastRequestTelemetryFromCache);
        List<FailedRequest> originalFailedRequests = lastRequestTelemetryFromCache.getFailedRequests();
        Set<FailedRequest> failedRequestSentSet = this.mSentFailedRequests.get(correlationId);
        boolean isAllDataSentInHeader = true;
        for (int i = 0; i < originalFailedRequests.size(); ++i) {
            if (lastRequestTelemetryCopy.getCompleteHeaderString().length() < 3800) {
                FailedRequest failedRequest = originalFailedRequests.get(i);
                lastRequestTelemetryCopy.appendFailedRequest(failedRequest);
                if (failedRequestSentSet == null) continue;
                failedRequestSentSet.add(failedRequest);
                continue;
            }
            isAllDataSentInHeader = false;
            break;
        }
        String isAllDataSentString = TelemetryUtils.getSchemaCompliantStringFromBoolean(isAllDataSentInHeader);
        lastRequestTelemetryCopy.putInPlatformTelemetry("is_all_telemetry_data_sent", isAllDataSentString);
        return lastRequestTelemetryCopy.getCompleteHeaderString();
    }

    @NonNull
    public Map<String, String> getTelemetryHeaders() {
        String methodName = ":getTelemetryHeaders";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (!this.isCurrentTelemetryAvailable()) {
            return headerMap;
        }
        String currentHeader = this.getCurrentTelemetryHeaderString();
        String lastHeader = this.getLastTelemetryHeaderString();
        if (currentHeader != null) {
            headerMap.put("x-client-current-telemetry", currentHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Current Request Telemetry Header is null");
        }
        if (lastHeader != null) {
            headerMap.put("x-client-last-telemetry", lastHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Last Request Telemetry Header is null");
        }
        return Collections.unmodifiableMap(headerMap);
    }

    private boolean isCurrentTelemetryAvailable() {
        String correlationId = (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id");
        CurrentRequestTelemetry currentRequestTelemetry = this.getCurrentTelemetryInstance(correlationId);
        return currentRequestTelemetry != null;
    }

    @Nullable
    private CurrentRequestTelemetry getCurrentTelemetryInstance(String correlationId) {
        if (this.mTelemetryMap == null || correlationId == null || correlationId.equals("UNSET")) {
            return null;
        }
        return this.mTelemetryMap.get(correlationId);
    }
}

