/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.eststelemetry;

import java.util.Arrays;

public class SchemaConstants {
    public static final String SCHEMA_VERSION_KEY = "schema_version";
    public static final String CURRENT_SCHEMA_VERSION = "2";
    public static final String CURRENT_REQUEST_HEADER_NAME = "x-client-current-telemetry";
    public static final String LAST_REQUEST_HEADER_NAME = "x-client-last-telemetry";
    public static final String SEPARATOR_PIPE = "|";
    public static final String SEPARATOR_COMMA = ",";
    public static final int HEADER_DATA_LIMIT = 3800;
    private static final String[] currentRequestPlatformFields = new String[]{"Microsoft.MSAL.account_status", "Microsoft.MSAL.id_token_status", "Microsoft.MSAL.at_status", "Microsoft.MSAL.rt_status", "Microsoft.MSAL.frt_status", "Microsoft.MSAL.mrrt_status"};
    private static final String[] lastRequestPlatformFields = new String[]{"is_all_telemetry_data_sent"};

    static boolean isCurrentPlatformField(String key) {
        return Arrays.asList(currentRequestPlatformFields).contains(key);
    }

    static boolean isLastPlatformField(String key) {
        return Arrays.asList(lastRequestPlatformFields).contains(key);
    }

    static String[] getCurrentRequestPlatformFields() {
        return currentRequestPlatformFields;
    }

    static String[] getLastRequestPlatformFields() {
        return lastRequestPlatformFields;
    }

    public static final class Value {
        public static final String TRUE = "1";
        public static final String FALSE = "0";
        public static final String EMPTY = "";
    }

    public static final class Key {
        public static final String API_ID = "Microsoft.MSAL.api_id";
        public static final String FORCE_REFRESH = "Microsoft.MSAL.force_refresh";
        public static final String CORRELATION_ID = "Microsoft.MSAL.correlation_id";
        public static final String ERROR_CODE = "Microsoft.MSAL.api_error_code";
        public static final String ACCOUNT_STATUS = "Microsoft.MSAL.account_status";
        public static final String ID_TOKEN_STATUS = "Microsoft.MSAL.id_token_status";
        public static final String AT_STATUS = "Microsoft.MSAL.at_status";
        public static final String RT_STATUS = "Microsoft.MSAL.rt_status";
        public static final String FRT_STATUS = "Microsoft.MSAL.frt_status";
        public static final String MRRT_STATUS = "Microsoft.MSAL.mrrt_status";
        public static final String ALL_TELEMETRY_DATA_SENT = "is_all_telemetry_data_sent";
    }
}

