/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.logging;

import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.IDetailedLoggerCallback;
import com.microsoft.identity.common.java.logging.ILoggerCallback;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThrowableUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;

public class Logger {
    private static final Object $LOCK = new Object[0];
    private static final ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String UNSET = "UNSET";
    private static LogLevel sLogLevel = LogLevel.VERBOSE;
    private static boolean sAllowPii = false;
    private static String sPlatformString = "";
    private static final ReentrantReadWriteLock sLoggersLock = new ReentrantReadWriteLock();
    private static final Map<String, ILoggerCallback> sLoggers = new HashMap<String, ILoggerCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPlatformString(String platformString) {
        Object object = $LOCK;
        synchronized (object) {
            sPlatformString = platformString;
        }
    }

    static synchronized void resetLogger() {
        sLoggersLock.writeLock().lock();
        try {
            sLoggers.clear();
            sAllowPii = false;
            sPlatformString = "";
            sLogLevel = LogLevel.VERBOSE;
        }
        finally {
            sLoggersLock.writeLock().unlock();
        }
    }

    public static boolean setLogger(@NonNull String identifier, ILoggerCallback callback) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        sLoggersLock.writeLock().lock();
        try {
            if (callback == null) {
                sLoggers.remove(identifier);
                boolean bl = true;
                return bl;
            }
            if (sLoggers.containsValue(callback)) {
                boolean bl = false;
                return bl;
            }
            sLoggers.put(identifier, callback);
            boolean bl = true;
            return bl;
        }
        finally {
            sLoggersLock.writeLock().unlock();
        }
    }

    public static synchronized String getDiagnosticContextMetadata() {
        String threadName = (String)DiagnosticContext.INSTANCE.getRequestContext().get("thread_name");
        String correlationId = (String)DiagnosticContext.INSTANCE.getRequestContext().get("correlation_id");
        if (StringUtil.isNullOrEmpty(threadName)) {
            threadName = UNSET;
        }
        if (StringUtil.isNullOrEmpty(correlationId)) {
            correlationId = UNSET;
        }
        return "thread_name : " + threadName + ", " + "correlation_id" + " : " + correlationId;
    }

    public static void error(String tag, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, Logger.getDiagnosticContextMetadata(), errorMessage, exception, false);
    }

    public static void error(String tag, String correlationID, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, false);
    }

    public static void errorPII(String tag, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, Logger.getDiagnosticContextMetadata(), errorMessage, exception, true);
    }

    public static void errorPII(String tag, String correlationID, String errorMessage, Throwable exception) {
        Logger.log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, true);
    }

    public static void warn(String tag, String message) {
        Logger.log(tag, LogLevel.WARN, Logger.getDiagnosticContextMetadata(), message, null, false);
    }

    public static void warn(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.WARN, correlationID, message, null, false);
    }

    public static void warnPII(String tag, String message) {
        Logger.log(tag, LogLevel.WARN, Logger.getDiagnosticContextMetadata(), message, null, true);
    }

    public static void warnPII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.WARN, correlationID, message, null, true);
    }

    public static void info(String tag, String message) {
        Logger.log(tag, LogLevel.INFO, Logger.getDiagnosticContextMetadata(), message, null, false);
    }

    public static void info(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.INFO, correlationID, message, null, false);
    }

    public static void infoPII(String tag, String message) {
        Logger.log(tag, LogLevel.INFO, Logger.getDiagnosticContextMetadata(), message, null, true);
    }

    public static void infoPII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.INFO, correlationID, message, null, true);
    }

    public static void verbose(String tag, String message) {
        Logger.log(tag, LogLevel.VERBOSE, Logger.getDiagnosticContextMetadata(), message, null, false);
    }

    public static void verbose(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.VERBOSE, correlationID, message, null, false);
    }

    public static void verbosePII(String tag, String message) {
        Logger.log(tag, LogLevel.VERBOSE, Logger.getDiagnosticContextMetadata(), message, null, true);
    }

    public static void verbosePII(String tag, String correlationID, String message) {
        Logger.log(tag, LogLevel.VERBOSE, correlationID, message, null, true);
    }

    private static void log(final String tag, final @NonNull LogLevel logLevel, final String correlationID, final String message, final Throwable throwable, final boolean containsPII) {
        if (logLevel == null) {
            throw new NullPointerException("logLevel is marked non-null but is null");
        }
        final String dateTimeStamp = Logger.getUTCDateTimeAsString();
        sLogExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                String logMessage = Logger.formatMessage(correlationID, message, dateTimeStamp, throwable);
                sLoggersLock.readLock().lock();
                try {
                    for (String loggerCallbackKey : sLoggers.keySet()) {
                        ILoggerCallback callback;
                        block9: {
                            callback = (ILoggerCallback)sLoggers.get(loggerCallbackKey);
                            if (callback == null) continue;
                            if (logLevel.compareTo(sLogLevel) <= 0) break block9;
                            Logger.logDiscardedLogIfApplicable(logMessage, callback, tag, logLevel, containsPII);
                            sLoggersLock.readLock().unlock();
                            return;
                            {
                                catch (Exception exception) {}
                            }
                        }
                        if (!sAllowPii && containsPII) {
                            Logger.logDiscardedLogIfApplicable(logMessage, callback, tag, logLevel, containsPII);
                            sLoggersLock.readLock().unlock();
                            return;
                        }
                        callback.log(tag, logLevel, logMessage, containsPII);
                    }
                    sLoggersLock.readLock().unlock();
                    return;
                }
                catch (Throwable throwable2) {
                    sLoggersLock.readLock().unlock();
                    throw throwable2;
                }
            }
        });
    }

    private static void logDiscardedLogIfApplicable(String logMessage, ILoggerCallback callback, @NonNull String tag, @NonNull LogLevel logLevel, boolean containsPII) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (logLevel == null) {
            throw new NullPointerException("logLevel is marked non-null but is null");
        }
        if (callback instanceof IDetailedLoggerCallback) {
            ((IDetailedLoggerCallback)callback).discardedLog(tag, logLevel, logMessage, containsPII);
        }
    }

    private static String formatMessage(String correlationID, String message, @NonNull String dateTimeStamp, Throwable throwable) {
        if (dateTimeStamp == null) {
            throw new NullPointerException("dateTimeStamp is marked non-null but is null");
        }
        String logMessage = StringUtil.isNullOrEmpty(message) ? "N/A" : message;
        return " [" + dateTimeStamp + (StringUtil.isNullOrEmpty(correlationID) ? "] " : " - " + correlationID + "] ") + sPlatformString + " " + logMessage + (throwable == null ? "" : '\n' + ThrowableUtil.getStackTraceAsString(throwable));
    }

    private static String getUTCDateTimeAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    public static void setLogLevel(LogLevel sLogLevel) {
        Logger.sLogLevel = sLogLevel;
    }

    public static LogLevel getLogLevel() {
        return sLogLevel;
    }

    public static void setAllowPii(boolean sAllowPii) {
        Logger.sAllowPii = sAllowPii;
    }

    public static boolean isAllowPii() {
        return sAllowPii;
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        VERBOSE,
        UNDEFINED;

    }
}

