/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import lombok.NonNull;

public interface HttpClient {
    public HttpResponse method(@NonNull String var1, @NonNull URL var2, @NonNull Map<String, String> var3, byte[] var4, SSLContext var5) throws IOException;

    public HttpResponse method(@NonNull HttpMethod var1, @NonNull URL var2, @NonNull Map<String, String> var3, byte[] var4, SSLContext var5) throws IOException;

    public HttpResponse put(@NonNull URL var1, @NonNull Map<String, String> var2, byte[] var3, SSLContext var4) throws IOException;

    public HttpResponse patch(@NonNull URL var1, @NonNull Map<String, String> var2, byte[] var3, SSLContext var4) throws IOException;

    public HttpResponse options(@NonNull URL var1, @NonNull Map<String, String> var2, SSLContext var3) throws IOException;

    public HttpResponse post(@NonNull URL var1, @NonNull Map<String, String> var2, byte[] var3, SSLContext var4) throws IOException;

    public HttpResponse delete(@NonNull URL var1, @NonNull Map<String, String> var2, byte[] var3, SSLContext var4) throws IOException;

    public HttpResponse get(@NonNull URL var1, @NonNull Map<String, String> var2, SSLContext var3) throws IOException;

    public HttpResponse head(@NonNull URL var1, @NonNull Map<String, String> var2, SSLContext var3) throws IOException;

    public HttpResponse trace(@NonNull URL var1, @NonNull Map<String, String> var2, SSLContext var3) throws IOException;

    public static enum HttpMethod {
        GET,
        HEAD,
        PUT,
        POST,
        OPTIONS,
        PATCH,
        DELETE,
        TRACE;

        private static final Map<String, HttpMethod> validMethods;

        public static HttpMethod validateAndNormalizeMethod(@NonNull String httpMethod) {
            if (httpMethod == null) {
                throw new NullPointerException("httpMethod is marked non-null but is null");
            }
            if (StringUtil.isNullOrEmpty(httpMethod)) {
                throw new IllegalArgumentException("HTTP method cannot be null or blank");
            }
            HttpMethod method = validMethods.get(httpMethod);
            if (method != null) {
                return method;
            }
            throw new IllegalArgumentException("Unknown or unsupported HTTP method: " + httpMethod);
        }

        static {
            validMethods = new LinkedHashMap<String, HttpMethod>(HttpMethod.values().length);
            for (HttpMethod method : HttpMethod.values()) {
                validMethods.put(method.name(), method);
            }
        }
    }
}

