/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.net.AbstractHttpClient;
import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpRequest;
import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.java.net.IRetryPolicy;
import com.microsoft.identity.common.java.net.NoRetryPolicy;
import com.microsoft.identity.common.java.net.SSLSocketFactoryWrapper;
import com.microsoft.identity.common.java.net.StatusCodeAndExceptionRetry;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.HttpEndEvent;
import com.microsoft.identity.common.java.telemetry.events.HttpStartEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Consumer;
import com.microsoft.identity.common.java.util.ported.Function;
import com.microsoft.identity.common.java.util.ported.Supplier;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.NonNull;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UrlConnectionHttpClient
extends AbstractHttpClient {
    private static final Object TAG = UrlConnectionHttpClient.class.getName();
    protected static final int RETRY_TIME_WAITING_PERIOD_MSEC = 1000;
    protected static final int STREAM_BUFFER_SIZE_BYTES = 1024;
    public static final int DEFAULT_CONNECT_TIME_OUT_MS = 30000;
    public static final int DEFAULT_READ_TIME_OUT_MS = 30000;
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 1024;
    private final IRetryPolicy<HttpResponse> retryPolicy;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Supplier<Integer> connectTimeoutMsSupplier;
    private final Supplier<Integer> readTimeoutMsSupplier;
    private final int streamBufferSize;
    private final List<String> supportedSslProtocol;
    private SSLSocketFactoryWrapper sDefault;
    private static final transient AtomicReference<UrlConnectionHttpClient> defaultReference = new AtomicReference<Object>(null);

    private synchronized SSLSocketFactoryWrapper getDefaultWrapper() {
        if (this.sDefault == null) {
            this.sDefault = new SSLSocketFactoryWrapper((SSLSocketFactory)SSLSocketFactory.getDefault(), this.supportedSslProtocol);
        }
        return this.sDefault;
    }

    public static synchronized UrlConnectionHttpClient getDefaultInstance() {
        UrlConnectionHttpClient reference = defaultReference.get();
        if (reference == null) {
            defaultReference.compareAndSet(null, UrlConnectionHttpClient.builder().streamBufferSize(1024).retryPolicy(StatusCodeAndExceptionRetry.builder().number(1).extensionFactor(2).isAcceptable(new Function<HttpResponse, Boolean>(){

                @Override
                public Boolean apply(HttpResponse response) {
                    return response != null && response.getStatusCode() < 400;
                }
            }).initialDelay(1000).isRetryable(new Function<HttpResponse, Boolean>(){

                @Override
                public Boolean apply(HttpResponse response) {
                    return response != null && UrlConnectionHttpClient.isRetryableError(response.getStatusCode());
                }
            }).isRetryableException(new Function<Exception, Boolean>(){

                @Override
                public Boolean apply(Exception e) {
                    return e instanceof SocketTimeoutException;
                }
            }).build()).build());
            reference = defaultReference.get();
        }
        return reference;
    }

    private static void recordHttpTelemetryEventStart(@NonNull String requestMethod, @NonNull URL requestUrl, String requestId) {
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        Telemetry.emit(new HttpStartEvent().putMethod(requestMethod).putPath(requestUrl).putRequestIdHeader(requestId));
    }

    private static void recordHttpTelemetryEventEnd(HttpResponse response) {
        HttpEndEvent httpEndEvent = new HttpEndEvent();
        if (null != response) {
            httpEndEvent.putStatusCode(response.getStatusCode());
        }
        Telemetry.emit(httpEndEvent);
    }

    @Override
    public HttpResponse method(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, byte[] requestContent, SSLContext sslContext) throws IOException {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        UrlConnectionHttpClient.recordHttpTelemetryEventStart(httpMethod.name(), requestUrl, requestHeaders.get("client-request-id"));
        final HttpRequest request = UrlConnectionHttpClient.constructHttpRequest(httpMethod, requestUrl, requestHeaders, requestContent, sslContext);
        return this.retryPolicy.attempt(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws IOException {
                return UrlConnectionHttpClient.this.executeHttpSend(request, new Consumer<HttpResponse>(){

                    @Override
                    public void accept(HttpResponse httpResponse) {
                        UrlConnectionHttpClient.recordHttpTelemetryEventEnd(httpResponse);
                    }
                });
            }
        });
    }

    private static HttpRequest constructHttpRequest(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, byte[] requestContent, SSLContext sslContext) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        if (HttpClient.HttpMethod.PATCH == httpMethod) {
            httpMethod = HttpClient.HttpMethod.POST;
            requestHeaders = new HashMap<String, String>(requestHeaders);
            requestHeaders.put("X-HTTP-Method-Override", HttpClient.HttpMethod.PATCH.name());
        }
        return new HttpRequest(requestUrl, requestHeaders, httpMethod.name(), requestContent, null, sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, AuthenticationConstants.CHARSET_UTF8));
            char[] buffer = new char[this.streamBufferSize];
            StringBuilder stringBuilder = new StringBuilder();
            while ((charsRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(inputStream);
        }
    }

    private static void safeCloseStream(Closeable stream) {
        String methodName = ":safeCloseStream";
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            Logger.error(TAG + ":safeCloseStream", "Encountered IO exception when trying to close the stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpSend(HttpRequest request, Consumer<HttpResponse> completionCallback) throws IOException {
        HttpURLConnection urlConnection = this.setupConnection(request);
        UrlConnectionHttpClient.sendRequest(urlConnection, request.getRequestContent(), request.getRequestHeaders().get("Content-Type"));
        InputStream responseStream = null;
        HttpResponse response = null;
        try {
            try {
                responseStream = urlConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw socketTimeoutException;
            }
            catch (IOException ioException) {
                responseStream = urlConnection.getErrorStream();
            }
            int statusCode = urlConnection.getResponseCode();
            Date date = new Date(urlConnection.getDate());
            String responseBody = responseStream == null ? "" : this.convertStreamToString(responseStream);
            response = new HttpResponse(date, statusCode, responseBody, urlConnection.getHeaderFields());
            completionCallback.accept(response);
        }
        catch (Throwable throwable) {
            completionCallback.accept(response);
            UrlConnectionHttpClient.safeCloseStream(responseStream);
            throw throwable;
        }
        UrlConnectionHttpClient.safeCloseStream(responseStream);
        return response;
    }

    private HttpURLConnection setupConnection(HttpRequest request) throws IOException {
        String methodName = ":setupConnection";
        HttpURLConnection urlConnection = HttpUrlConnectionFactory.createHttpURLConnection(request.getRequestUrl());
        Set<Map.Entry<String, String>> headerEntries = request.getRequestHeaders().entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (urlConnection instanceof HttpsURLConnection) {
            SSLSocketFactoryWrapper factory = request.getSslContext() != null ? new SSLSocketFactoryWrapper(request.getSslContext().getSocketFactory(), this.supportedSslProtocol) : this.getDefaultWrapper();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(factory);
        } else {
            if ("https".equalsIgnoreCase(request.getRequestUrl().getProtocol())) {
                throw new IllegalStateException("Trying to initiate a HTTPS request, but didn't get back HttpsURLConnection");
            }
            if ("http".equalsIgnoreCase(request.getRequestUrl().getProtocol())) {
                Logger.warn(TAG + ":setupConnection", "Making a request for non-https URL.");
            } else {
                Logger.warn(TAG + ":setupConnection", "gets a request from an unexpected protocol: " + request.getRequestUrl().getProtocol());
            }
        }
        urlConnection.setRequestMethod(request.getRequestMethod());
        urlConnection.setConnectTimeout(this.getConnectTimeoutMs());
        urlConnection.setReadTimeout(this.getReadTimeoutMs());
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setUseCaches(true);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    private int getReadTimeoutMs() {
        return this.readTimeoutMsSupplier == null ? this.readTimeoutMs : this.readTimeoutMsSupplier.get();
    }

    private int getConnectTimeoutMs() {
        return this.connectTimeoutMsSupplier == null ? this.connectTimeoutMs : this.connectTimeoutMsSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(@NonNull HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (contentRequest == null) {
            return;
        }
        connection.setDoOutput(true);
        if (!StringUtil.isNullOrEmpty(requestContentType)) {
            connection.setRequestProperty("Content-Type", requestContentType);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(contentRequest.length));
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(contentRequest);
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(out);
        }
    }

    public static boolean isRetryableError(int statusCode) {
        return statusCode == 500 || statusCode == 504 || statusCode == 503;
    }

    private static IRetryPolicy<HttpResponse> $default$retryPolicy() {
        return new NoRetryPolicy();
    }

    private static int $default$connectTimeoutMs() {
        return 30000;
    }

    private static int $default$readTimeoutMs() {
        return 30000;
    }

    private static Supplier<Integer> $default$connectTimeoutMsSupplier() {
        return null;
    }

    private static Supplier<Integer> $default$readTimeoutMsSupplier() {
        return null;
    }

    private static int $default$streamBufferSize() {
        return 1024;
    }

    private static List<String> $default$supportedSslProtocol() {
        return SSLSocketFactoryWrapper.SUPPORTED_SSL_PROTOCOLS;
    }

    public static UrlConnectionHttpClientBuilder builder() {
        return new UrlConnectionHttpClientBuilder();
    }

    public UrlConnectionHttpClient(IRetryPolicy<HttpResponse> retryPolicy, int connectTimeoutMs, int readTimeoutMs, Supplier<Integer> connectTimeoutMsSupplier, Supplier<Integer> readTimeoutMsSupplier, int streamBufferSize, List<String> supportedSslProtocol, SSLSocketFactoryWrapper sDefault) {
        this.retryPolicy = retryPolicy;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.connectTimeoutMsSupplier = connectTimeoutMsSupplier;
        this.readTimeoutMsSupplier = readTimeoutMsSupplier;
        this.streamBufferSize = streamBufferSize;
        this.supportedSslProtocol = supportedSslProtocol;
        this.sDefault = sDefault;
    }

    public static class UrlConnectionHttpClientBuilder {
        private boolean retryPolicy$set;
        private IRetryPolicy<HttpResponse> retryPolicy$value;
        private boolean connectTimeoutMs$set;
        private int connectTimeoutMs$value;
        private boolean readTimeoutMs$set;
        private int readTimeoutMs$value;
        private boolean connectTimeoutMsSupplier$set;
        private Supplier<Integer> connectTimeoutMsSupplier$value;
        private boolean readTimeoutMsSupplier$set;
        private Supplier<Integer> readTimeoutMsSupplier$value;
        private boolean streamBufferSize$set;
        private int streamBufferSize$value;
        private boolean supportedSslProtocol$set;
        private List<String> supportedSslProtocol$value;
        private SSLSocketFactoryWrapper sDefault;

        UrlConnectionHttpClientBuilder() {
        }

        public UrlConnectionHttpClientBuilder retryPolicy(IRetryPolicy<HttpResponse> retryPolicy) {
            this.retryPolicy$value = retryPolicy;
            this.retryPolicy$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs$value = connectTimeoutMs;
            this.connectTimeoutMs$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMs(int readTimeoutMs) {
            this.readTimeoutMs$value = readTimeoutMs;
            this.readTimeoutMs$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMsSupplier(Supplier<Integer> connectTimeoutMsSupplier) {
            this.connectTimeoutMsSupplier$value = connectTimeoutMsSupplier;
            this.connectTimeoutMsSupplier$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMsSupplier(Supplier<Integer> readTimeoutMsSupplier) {
            this.readTimeoutMsSupplier$value = readTimeoutMsSupplier;
            this.readTimeoutMsSupplier$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder streamBufferSize(int streamBufferSize) {
            this.streamBufferSize$value = streamBufferSize;
            this.streamBufferSize$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder supportedSslProtocol(List<String> supportedSslProtocol) {
            this.supportedSslProtocol$value = supportedSslProtocol;
            this.supportedSslProtocol$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder sDefault(SSLSocketFactoryWrapper sDefault) {
            this.sDefault = sDefault;
            return this;
        }

        public UrlConnectionHttpClient build() {
            IRetryPolicy retryPolicy$value = this.retryPolicy$value;
            if (!this.retryPolicy$set) {
                retryPolicy$value = UrlConnectionHttpClient.$default$retryPolicy();
            }
            int connectTimeoutMs$value = this.connectTimeoutMs$value;
            if (!this.connectTimeoutMs$set) {
                connectTimeoutMs$value = UrlConnectionHttpClient.$default$connectTimeoutMs();
            }
            int readTimeoutMs$value = this.readTimeoutMs$value;
            if (!this.readTimeoutMs$set) {
                readTimeoutMs$value = UrlConnectionHttpClient.$default$readTimeoutMs();
            }
            Supplier connectTimeoutMsSupplier$value = this.connectTimeoutMsSupplier$value;
            if (!this.connectTimeoutMsSupplier$set) {
                connectTimeoutMsSupplier$value = UrlConnectionHttpClient.$default$connectTimeoutMsSupplier();
            }
            Supplier readTimeoutMsSupplier$value = this.readTimeoutMsSupplier$value;
            if (!this.readTimeoutMsSupplier$set) {
                readTimeoutMsSupplier$value = UrlConnectionHttpClient.$default$readTimeoutMsSupplier();
            }
            int streamBufferSize$value = this.streamBufferSize$value;
            if (!this.streamBufferSize$set) {
                streamBufferSize$value = UrlConnectionHttpClient.$default$streamBufferSize();
            }
            List supportedSslProtocol$value = this.supportedSslProtocol$value;
            if (!this.supportedSslProtocol$set) {
                supportedSslProtocol$value = UrlConnectionHttpClient.$default$supportedSslProtocol();
            }
            return new UrlConnectionHttpClient(retryPolicy$value, connectTimeoutMs$value, readTimeoutMs$value, connectTimeoutMsSupplier$value, readTimeoutMsSupplier$value, streamBufferSize$value, supportedSslProtocol$value, this.sDefault);
        }

        public String toString() {
            return "UrlConnectionHttpClient.UrlConnectionHttpClientBuilder(retryPolicy$value=" + this.retryPolicy$value + ", connectTimeoutMs$value=" + this.connectTimeoutMs$value + ", readTimeoutMs$value=" + this.readTimeoutMs$value + ", connectTimeoutMsSupplier$value=" + this.connectTimeoutMsSupplier$value + ", readTimeoutMsSupplier$value=" + this.readTimeoutMsSupplier$value + ", streamBufferSize$value=" + this.streamBufferSize$value + ", supportedSslProtocol$value=" + this.supportedSslProtocol$value + ", sDefault=" + this.sDefault + ")";
        }
    }
}

