/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft;

import com.microsoft.identity.common.java.providers.keys.CertificateCredential;
import com.microsoft.identity.common.java.providers.oauth2.ClientAssertion;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

public class MicrosoftClientAssertion
extends ClientAssertion {
    private static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private static final String THUMBPRINT_ALGORITHM = "SHA-1";
    private static final int ONE_MINUTE_MILLIS = 60000;

    public MicrosoftClientAssertion(String audience, CertificateCredential credential) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (credential == null) {
            throw new IllegalArgumentException("certificate credential is null");
        }
        SignedJWT assertion = this.createSignedJwt(credential.getClientId(), audience, credential);
        this.setClientAssertion(assertion.serialize());
        this.setClientAssertionType(CLIENT_ASSERTION_TYPE);
    }

    private SignedJWT createSignedJwt(String clientId, String audience, CertificateCredential credential) throws NoSuchAlgorithmException, CertificateEncodingException {
        SignedJWT jwt;
        long time = System.currentTimeMillis();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().audience(audience).issuer(clientId).notBeforeTime(new Date(time)).expirationTime(new Date(time + 60000L)).subject(clientId).build();
        try {
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256);
            ArrayList<Base64> certs = new ArrayList<Base64>();
            certs.add(Base64.encode((byte[])credential.getPublicCertificate().getEncoded()));
            builder.x509CertChain(certs);
            builder.x509CertThumbprint(this.createSHA1ThumbPrint(credential.getPublicCertificate()));
            jwt = new SignedJWT(builder.build(), claimsSet);
            RSASSASigner signer = new RSASSASigner(credential.getPrivateKey());
            jwt.sign((JWSSigner)signer);
        }
        catch (Exception e) {
            throw new RuntimeException("exception in createSignedJwt", e);
        }
        return jwt;
    }

    private Base64URL createSHA1ThumbPrint(X509Certificate clientCertificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        MessageDigest mdSha1 = MessageDigest.getInstance(THUMBPRINT_ALGORITHM);
        mdSha1.reset();
        mdSha1.update(clientCertificate.getEncoded());
        Base64URL thumbprint = new Base64URL(Base64.encode((byte[])mdSha1.digest()).toString());
        return thumbprint;
    }
}

