/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft;

import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class MicrosoftRefreshToken
extends RefreshToken {
    private ClientInfo mClientInfo;
    private String mFamilyId;
    private String mScope;
    private String mClientId;
    private String mEnvironment;

    public MicrosoftRefreshToken(String rawRefreshToken, ClientInfo clientInfo, String scope, String clientId, String environment, @Nullable String familyId) {
        super(rawRefreshToken);
        this.mClientInfo = clientInfo;
        this.mScope = scope;
        this.mClientId = clientId;
        this.mEnvironment = environment;
        this.mFamilyId = familyId;
    }

    public MicrosoftRefreshToken(@NonNull MicrosoftTokenResponse tokenResponse) {
        super(tokenResponse);
        if (tokenResponse == null) {
            throw new NullPointerException("tokenResponse is marked non-null but is null");
        }
        try {
            this.mClientInfo = new ClientInfo(tokenResponse.getClientInfo());
            this.mFamilyId = tokenResponse.getFamilyId();
            this.mScope = tokenResponse.getScope();
            this.mClientId = tokenResponse.getClientId();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHomeAccountId() {
        return SchemaUtil.getHomeAccountId(this.mClientInfo);
    }

    public void setEnvironment(String environment) {
        this.mEnvironment = environment;
    }

    @Override
    public String getEnvironment() {
        return this.mEnvironment;
    }

    @Override
    public String getClientId() {
        return this.mClientId;
    }

    @Override
    public String getSecret() {
        return this.getRefreshToken();
    }

    @Override
    public String getTarget() {
        return this.mScope;
    }

    @Override
    public String getFamilyId() {
        return this.mFamilyId;
    }

    public boolean getIsFamilyRefreshToken() {
        return !StringUtil.isNullOrEmpty(this.mFamilyId);
    }

    public ClientInfo getClientInfo() {
        return this.mClientInfo;
    }
}

